/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.lib.StringConverter;

public class DataOutputStream
extends BufferedOutputStream
implements DataOutput {
    byte[] tempBuffer = new byte[8];

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream, 8);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        int n2 = 0;
        this.tempBuffer[n2++] = (byte)(n >>> 24);
        this.tempBuffer[n2++] = (byte)(n >>> 16);
        this.tempBuffer[n2++] = (byte)(n >>> 8);
        this.tempBuffer[n2++] = (byte)n;
        this.write(this.tempBuffer, 0, n2);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    @Override
    public void writeChar(int n) throws IOException {
        int n2 = 0;
        this.tempBuffer[n2++] = (byte)(n >>> 8);
        this.tempBuffer[n2++] = (byte)n;
        this.write(this.tempBuffer, 0, n2);
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            int n2 = 0;
            this.tempBuffer[n2++] = (byte)(c2 >>> 8);
            this.tempBuffer[n2++] = (byte)c2;
            this.write(this.tempBuffer, 0, n2);
        }
    }

    public void writeChars(char[] cArray) throws IOException {
        this.writeChars(cArray, cArray.length);
    }

    public void writeChars(char[] cArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            char c2 = cArray[i];
            int n2 = 0;
            this.tempBuffer[n2++] = (byte)(c2 >>> 8);
            this.tempBuffer[n2++] = (byte)c2;
            this.write(this.tempBuffer, 0, n2);
        }
    }

    public long write(Reader reader, long l) throws IOException {
        ReaderInputStream readerInputStream = new ReaderInputStream(reader);
        return this.write(readerInputStream, l * 2L) / 2L;
    }

    public long write(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[1024];
        long l2 = 0L;
        while (true) {
            long l3;
            if ((l3 = l - l2) > (long)byArray.length) {
                l3 = byArray.length;
            }
            if ((l3 = (long)inputStream.read(byArray, 0, (int)l3)) < 1L) break;
            this.write(byArray, 0, (int)l3);
            l2 += l3;
        }
        return l2;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        int n = bl ? 1 : 0;
        this.write(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        int n2 = 0;
        this.tempBuffer[n2++] = (byte)(n >> 8);
        this.tempBuffer[n2++] = (byte)n;
        this.write(this.tempBuffer, 0, n2);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string.charAt(i));
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        int n = string.length();
        if (n > 65535) {
            throw new UTFDataFormatException();
        }
        int n2 = StringConverter.getUTFSize(string);
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeChar(n2);
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n2);
        StringConverter.stringToUTFBytes(string, hsqlByteArrayOutputStream);
        this.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
    }
}

