/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.kernel;

import java.util.Arrays;

class KernelFactoryHelper {
    private static final float FTOL = 1.0E-8f;
    private static final double DTOL = 1.0E-8;

    KernelFactoryHelper() {
    }

    float[] makeCircle(int radius) {
        int w = 2 * radius + 1;
        float[] m3 = new float[w * w];
        int[] offset = new int[w];
        int i = 0;
        int o = 0;
        while (i < w) {
            offset[i] = o;
            ++i;
            o += w;
        }
        int x = radius;
        int y = 0;
        int r2 = radius * radius;
        while (x > 0) {
            int ix = radius + x;
            int iy = radius + y;
            m3[ix + offset[iy]] = 1.0f;
            m3[w - 1 - ix + offset[iy]] = 1.0f;
            iy = w - 1 - iy;
            m3[ix + offset[iy]] = 1.0f;
            m3[w - 1 - ix + offset[iy]] = 1.0f;
            x = (int)Math.sqrt(r2 - --y * y);
        }
        m3[radius] = 1.0f;
        m3[radius + offset[2 * radius]] = 1.0f;
        return m3;
    }

    float[] makeRect(int w, int h2, float value) {
        float[] m3 = new float[w * h2];
        Arrays.fill(m3, value);
        return m3;
    }

    void rowFill(float[] data, int w, int h2, float value) {
        int k = 0;
        for (int y = 0; y < h2; ++y) {
            int left = -1;
            int right = -1;
            int x = 0;
            while (x < w) {
                if (data[k] > 0.0f) {
                    if (left < 0) {
                        left = k;
                    } else {
                        right = k;
                    }
                }
                ++x;
                ++k;
            }
            while (right > left + 1) {
                data[--right] = value;
            }
        }
    }

    float normalizeAngle(float angle) {
        while ((double)angle < -Math.PI) {
            angle = (float)((double)angle + Math.PI * 2);
        }
        while ((double)angle > Math.PI) {
            angle = (float)((double)angle - Math.PI * 2);
        }
        return angle;
    }

    float normalizeAnglePositive(float angle) {
        while (angle < 0.0f) {
            angle = (float)((double)angle + Math.PI * 2);
        }
        while ((double)angle > Math.PI * 2) {
            angle = (float)((double)angle - Math.PI * 2);
        }
        return angle;
    }
}

