/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.AbstractFundamentalCycleBasis;

public class QueueBFSFundamentalCycleBasis<V, E>
extends AbstractFundamentalCycleBasis<V, E> {
    public QueueBFSFundamentalCycleBasis(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    protected Map<V, E> computeSpanningForest() {
        HashMap pred = new HashMap();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        for (Object s2 : this.graph.vertexSet()) {
            if (pred.containsKey(s2)) continue;
            pred.put(s2, null);
            queue.addLast(s2);
            while (!queue.isEmpty()) {
                Object v = queue.removeFirst();
                for (Object e2 : this.graph.edgesOf(v)) {
                    Object u = Graphs.getOppositeVertex(this.graph, e2, v);
                    if (pred.containsKey(u)) continue;
                    pred.put(u, e2);
                    queue.addLast(u);
                }
            }
        }
        return pred;
    }
}

