/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Map;
import org.jgrapht.graph.BaseIntrusiveEdgesSpecifics;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;
import org.jgrapht.graph.IntrusiveWeightedEdge;

public class WeightedIntrusiveEdgesSpecifics<V, E>
extends BaseIntrusiveEdgesSpecifics<V, E, IntrusiveWeightedEdge>
implements IntrusiveEdgesSpecifics<V, E> {
    private static final long serialVersionUID = 5327226615635500554L;

    public WeightedIntrusiveEdgesSpecifics(Map<E, IntrusiveWeightedEdge> map) {
        super(map);
    }

    @Override
    public boolean add(E e2, V sourceVertex, V targetVertex) {
        IntrusiveWeightedEdge intrusiveEdge = e2 instanceof IntrusiveWeightedEdge ? (IntrusiveWeightedEdge)e2 : new IntrusiveWeightedEdge();
        intrusiveEdge.source = sourceVertex;
        intrusiveEdge.target = targetVertex;
        return this.edgeMap.putIfAbsent(e2, intrusiveEdge) == null;
    }

    @Override
    public double getEdgeWeight(E e2) {
        IntrusiveEdge ie = this.getIntrusiveEdge((Object)e2);
        if (ie == null) {
            throw new IllegalArgumentException("no such edge in graph: " + e2.toString());
        }
        return ((IntrusiveWeightedEdge)ie).weight;
    }

    @Override
    public void setEdgeWeight(E e2, double weight) {
        IntrusiveEdge ie = this.getIntrusiveEdge((Object)e2);
        if (ie == null) {
            throw new IllegalArgumentException("no such edge in graph: " + e2.toString());
        }
        ((IntrusiveWeightedEdge)ie).weight = weight;
    }

    @Override
    protected IntrusiveWeightedEdge getIntrusiveEdge(E e2) {
        if (e2 instanceof IntrusiveWeightedEdge) {
            return (IntrusiveWeightedEdge)e2;
        }
        return (IntrusiveWeightedEdge)this.edgeMap.get(e2);
    }
}

