/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.union.OverlapUnion;

public class CascadedPolygonUnion {
    private Collection inputPolys;
    private GeometryFactory geomFactory = null;
    private static final int STRTREE_NODE_CAPACITY = 4;

    public static Geometry union(Collection polys) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys);
        return op.union();
    }

    public CascadedPolygonUnion(Collection polys) {
        this.inputPolys = polys;
        if (this.inputPolys == null) {
            this.inputPolys = new ArrayList();
        }
    }

    public Geometry union() {
        if (this.inputPolys == null) {
            throw new IllegalStateException("union() method cannot be called twice");
        }
        if (this.inputPolys.isEmpty()) {
            return null;
        }
        this.geomFactory = ((Geometry)this.inputPolys.iterator().next()).getFactory();
        STRtree index = new STRtree(4);
        for (Geometry item : this.inputPolys) {
            index.insert(item.getEnvelopeInternal(), (Object)item);
        }
        this.inputPolys = null;
        List itemTree = index.itemsTree();
        Geometry unionAll = this.unionTree(itemTree);
        return unionAll;
    }

    private Geometry unionTree(List geomTree) {
        List geoms = this.reduceToGeometries(geomTree);
        Geometry union = this.binaryUnion(geoms);
        return union;
    }

    private Geometry repeatedUnion(List geoms) {
        Geometry union = null;
        for (Geometry g2 : geoms) {
            if (union == null) {
                union = g2.copy();
                continue;
            }
            union = union.union(g2);
        }
        return union;
    }

    private Geometry bufferUnion(List geoms) {
        GeometryFactory factory = ((Geometry)geoms.get(0)).getFactory();
        Geometry gColl = factory.buildGeometry(geoms);
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    private Geometry bufferUnion(Geometry g0, Geometry g1) {
        GeometryFactory factory = g0.getFactory();
        GeometryCollection gColl = factory.createGeometryCollection(new Geometry[]{g0, g1});
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    private Geometry binaryUnion(List geoms) {
        return this.binaryUnion(geoms, 0, geoms.size());
    }

    private Geometry binaryUnion(List geoms, int start, int end) {
        if (end - start <= 1) {
            Geometry g0 = CascadedPolygonUnion.getGeometry(geoms, start);
            return this.unionSafe(g0, null);
        }
        if (end - start == 2) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(geoms, start), CascadedPolygonUnion.getGeometry(geoms, start + 1));
        }
        int mid = (end + start) / 2;
        Geometry g0 = this.binaryUnion(geoms, start, mid);
        Geometry g1 = this.binaryUnion(geoms, mid, end);
        return this.unionSafe(g0, g1);
    }

    private static Geometry getGeometry(List list, int index) {
        if (index >= list.size()) {
            return null;
        }
        return (Geometry)list.get(index);
    }

    private List reduceToGeometries(List geomTree) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object o : geomTree) {
            Geometry geom = null;
            if (o instanceof List) {
                geom = this.unionTree((List)o);
            } else if (o instanceof Geometry) {
                geom = (Geometry)o;
            }
            geoms.add(geom);
        }
        return geoms;
    }

    private Geometry unionSafe(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g0 == null) {
            return g1.copy();
        }
        if (g1 == null) {
            return g0.copy();
        }
        return this.unionActual(g0, g1);
    }

    private Geometry unionActual(Geometry g0, Geometry g1) {
        Geometry union = OverlapUnion.union(g0, g1);
        return CascadedPolygonUnion.restrictToPolygons(union);
    }

    private static Geometry restrictToPolygons(Geometry g2) {
        if (g2 instanceof Polygonal) {
            return g2;
        }
        List polygons = PolygonExtracter.getPolygons(g2);
        if (polygons.size() == 1) {
            return (Polygon)polygons.get(0);
        }
        return g2.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
    }
}

