/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.selectors;

import org.vikamine.kernel.data.discretization.EqualFreqDiscretizer;
import org.vikamine.kernel.data.discretization.EqualWidthDiscretizer;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;

public final class SGSelectorGeneratorFactory {
    public static SGSelectorGenerator createSimpleValueGenerator() {
        return SGSelectorGeneratorFactory.createStandardGenerator(false);
    }

    public static SGSelectorGenerator createSimpleValueGenerator(boolean ignoreDefaults) {
        if (ignoreDefaults) {
            return new SGSelectorGenerator.SimpleValueSelectorGeneratorIgnoreDefaults();
        }
        return new SGSelectorGenerator.SimpleValueSelectorGenerator();
    }

    public static SGSelectorGenerator createOnlyNumericGenerator() {
        return SGSelectorGeneratorFactory.createOnlyNumericGenerator(5);
    }

    public static SGSelectorGenerator createOnlyNumericGenerator(int nbins) {
        return new SGSelectorGenerator.SplitSelectorGenerator(new SGSelectorGenerator.EmptySelectorSetGenerator(), new SGSelectorGenerator.SimpleNumericSelectorGenerator(new EqualFreqDiscretizer(nbins)));
    }

    public static SGSelectorGenerator createStandardGenerator() {
        return SGSelectorGeneratorFactory.createStandardGenerator(true);
    }

    public static SGSelectorGenerator createStandardGenerator(boolean ignoreDefaults) {
        return new SGSelectorGenerator.SplitSelectorGenerator(SGSelectorGeneratorFactory.createSimpleValueGenerator(ignoreDefaults), new SGSelectorGenerator.SimpleNumericSelectorGenerator(new EqualFreqDiscretizer(5)));
    }

    public static SGSelectorGenerator createStandardGenerator(int numberOfIntervals, boolean ignoreDefaults) {
        return new SGSelectorGenerator.SplitSelectorGenerator(SGSelectorGeneratorFactory.createSimpleValueGenerator(ignoreDefaults), new SGSelectorGenerator.SimpleNumericSelectorGenerator(new EqualFreqDiscretizer(numberOfIntervals)));
    }

    public static SGSelectorGenerator createIntervalGenerator(boolean ignoreDefaults) {
        return new SGSelectorGenerator.SplitSelectorGenerator(SGSelectorGeneratorFactory.createSimpleValueGenerator(ignoreDefaults), new SGSelectorGenerator.AllExtremeValueBasedSelectorGenerator(new EqualFreqDiscretizer(5), false));
    }

    public static SGSelectorGenerator createIntervalGeneratorPlusSimpleIntervals(boolean ignoreDefaults) {
        return new SGSelectorGenerator.SplitSelectorGenerator(SGSelectorGeneratorFactory.createSimpleValueGenerator(ignoreDefaults), new SGSelectorGenerator.AllExtremeValueBasedSelectorGenerator(new EqualFreqDiscretizer(5), true));
    }

    public static SGSelectorGenerator createIntervalGeneratorPlusSimpleIntervalsEqualWidth(boolean ignoreDefaults) {
        return new SGSelectorGenerator.SplitSelectorGenerator(SGSelectorGeneratorFactory.createSimpleValueGenerator(ignoreDefaults), new SGSelectorGenerator.AllExtremeValueBasedSelectorGenerator(new EqualWidthDiscretizer(5), true));
    }
}

