/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evomodel.continuous.IntegratedMultivariateTraitLikelihood;
import dr.evomodel.tree.TreeModel;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public interface MissingTraits {
    public void handleMissingTips();

    public boolean isCompletelyMissing(int var1);

    public boolean isPartiallyMissing(int var1);

    public void computeWeightedAverage(double[] var1, int var2, double var3, int var5, double var6, int var8, int var9);

    public static class PartiallyMissing
    extends Abstract {
        PartiallyMissing(TreeModel treeModel, List<Integer> list, int n) {
            super(treeModel, list, n);
        }

        @Override
        public void handleMissingTips() {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public boolean isCompletelyMissing(int n) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public boolean isPartiallyMissing(int n) {
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public void computeWeightedAverage(double[] dArray, int n, double d, int n2, double d2, int n3, int n4) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public static class CompletelyMissing
    extends Abstract {
        CompletelyMissing(MutableTreeModel mutableTreeModel, List<Integer> list, int n) {
            super(mutableTreeModel, list, n);
        }

        @Override
        public void handleMissingTips() {
            for (Integer n : this.missingIndices) {
                int n2 = n / this.dim;
                Logger.getLogger("dr.evomodel").info("\tMarking taxon " + this.treeModel.getTaxonId(n2) + " as completely missing");
                this.completelyMissing[n2] = true;
            }
        }

        @Override
        public boolean isCompletelyMissing(int n) {
            return this.completelyMissing[n];
        }

        @Override
        public boolean isPartiallyMissing(int n) {
            return false;
        }

        @Override
        public void computeWeightedAverage(double[] dArray, int n, double d, int n2, double d2, int n3, int n4) {
            IntegratedMultivariateTraitLikelihood.computeWeightedAverage(dArray, n, d, dArray, n2, d2, dArray, n3, n4);
        }
    }

    public static abstract class Abstract
    implements MissingTraits {
        protected static final boolean DEBUG = false;
        protected final MutableTreeModel treeModel;
        protected final int dim;
        protected final List<Integer> missingIndices;
        protected final boolean[] completelyMissing;

        Abstract(MutableTreeModel mutableTreeModel, List<Integer> list, int n) {
            this.treeModel = mutableTreeModel;
            this.dim = n;
            this.missingIndices = list;
            this.completelyMissing = new boolean[mutableTreeModel.getNodeCount()];
            Arrays.fill(this.completelyMissing, 0, mutableTreeModel.getExternalNodeCount(), false);
            Arrays.fill(this.completelyMissing, mutableTreeModel.getExternalNodeCount(), mutableTreeModel.getNodeCount(), true);
        }
    }
}

