/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.KMLCoordinates;
import dr.geo.Polygon2D;
import dr.geo.Polygon2DFactory;
import dr.geo.cartogram.CartogramMapping;
import dr.util.HeapSort;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class AbstractPolygon2D {
    public static final String POLYGON = "polygon";
    public static final String CLOSED = "closed";
    public static final String FILL_VALUE = "fillValue";
    public static final String CIRCLE = "circle";
    public static final String NUMBER_OF_POINTS = "numberOfPoints";
    public static final String RADIUS = "radius";
    public static final String CENTER = "center";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    private static boolean TRY_ROUGH = false;
    private double[][] minMax = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new ElementRule(KMLCoordinates.class), new ElementRule(Polygon2D.class)), AttributeRule.newBooleanRule("closed", true), AttributeRule.newDoubleRule("fillValue", true)};

        @Override
        public String getParserName() {
            return AbstractPolygon2D.POLYGON;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Polygon2D polygon2D;
            LinkedList<Point2D> linkedList = new LinkedList<Point2D>();
            if (xMLObject.getChild(Polygon2D.class) != null) {
                polygon2D = (Polygon2D)xMLObject.getChild(Polygon2D.class);
            } else {
                KMLCoordinates kMLCoordinates = (KMLCoordinates)xMLObject.getChild(KMLCoordinates.class);
                boolean bl = xMLObject.getAttribute(AbstractPolygon2D.CLOSED, false);
                if (!bl && kMLCoordinates.length < 3 || bl && kMLCoordinates.length < 4) {
                    throw new XMLParseException("Insufficient point2Ds in polygon '" + xMLObject.getId() + "' to define a polygon in 2D");
                }
                for (int i = 0; i < kMLCoordinates.length; ++i) {
                    linkedList.add(new Point2D.Double(kMLCoordinates.x[i], kMLCoordinates.y[i]));
                }
                polygon2D = new Polygon2D(linkedList, bl);
            }
            polygon2D.setFillValue(xMLObject.getAttribute(AbstractPolygon2D.FILL_VALUE, 0.0));
            return polygon2D;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a polygon.";
        }

        @Override
        public Class getReturnType() {
            return Polygon2D.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    public static XMLObjectParser CIRCLE_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("latitude"), AttributeRule.newDoubleRule("longitude"), AttributeRule.newDoubleRule("radius"), AttributeRule.newIntegerRule("numberOfPoints", true)};

        @Override
        public String getParserName() {
            return AbstractPolygon2D.CIRCLE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute(AbstractPolygon2D.LATITUDE);
            double d2 = xMLObject.getDoubleAttribute(AbstractPolygon2D.LONGITUDE);
            double d3 = xMLObject.getDoubleAttribute(AbstractPolygon2D.RADIUS);
            int n = xMLObject.getAttribute(AbstractPolygon2D.NUMBER_OF_POINTS, 50);
            LinkedList linkedList = AbstractPolygon2D.getCirclePoints(d, d2, n, d3);
            return new Polygon2D(linkedList, true);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a regular circle polygon.";
        }

        @Override
        public Class getReturnType() {
            return Polygon2D.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    protected List<Point2D> point2Ds;
    protected int length;
    protected String id;
    protected double[] x;
    protected double[] y;
    protected double[] max;
    protected double[] min;

    public String getID() {
        return this.id;
    }

    protected void parseCoordinates(Element element) {
        if (element.getName().equalsIgnoreCase("coordinates")) {
            String string = element.getTextTrim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n ");
            int n = stringTokenizer.countTokens();
            this.point2Ds = new ArrayList<Point2D>(n);
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                if (stringTokenizer2.countTokens() < 2 || stringTokenizer2.countTokens() > 3) {
                    throw new IllegalArgumentException("All KML coordinates must contain (X,Y) or (X,Y,Z) values.  Error in element '" + string2 + "'");
                }
                double d = Double.valueOf(stringTokenizer2.nextToken());
                double d2 = Double.valueOf(stringTokenizer2.nextToken());
                this.point2Ds.add(new Point2D.Double(d, d2));
            }
            this.convertPointsToArrays();
            this.length = this.point2Ds.size() - 1;
        } else {
            for (Object e : element.getChildren()) {
                if (!(e instanceof Element)) continue;
                this.parseCoordinates((Element)e);
            }
        }
    }

    Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        List<Point2D> list = this.point2Ds;
        generalPath.moveTo((float)list.get(0).getX(), (float)list.get(0).getY());
        for (int i = 1; i < list.size(); ++i) {
            generalPath.lineTo((float)list.get(i).getX(), (float)list.get(i).getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    protected void convertPointsToArrays() {
        int n = this.point2Ds.size();
        if (this.x == null || this.x.length != n) {
            this.x = new double[n];
            this.y = new double[n];
        }
        Iterator<Point2D> iterator = this.point2Ds.iterator();
        for (int i = 0; i < n; ++i) {
            Point2D point2D = iterator.next();
            this.x[i] = point2D.getX();
            this.y[i] = point2D.getY();
        }
    }

    public void addPoint2D(Point2D point2D) {
        if (this.point2Ds.size() == 0) {
            this.point2Ds.add(point2D);
        } else if (this.point2Ds.size() == 1) {
            this.point2Ds.add(point2D);
            this.point2Ds.add(this.point2Ds.get(0));
        } else {
            Point2D point2D2 = this.point2Ds.remove(this.point2Ds.size() - 1);
            this.point2Ds.add(point2D);
            if (!point2D2.equals(point2D)) {
                this.point2Ds.add(point2D2);
            }
        }
        this.convertPointsToArrays();
        this.length = this.point2Ds.size() - 1;
    }

    public Point2D getPoint2D(int n) {
        if (n > this.length + 1) {
            throw new RuntimeException("Polygon only has length" + this.length);
        }
        return this.point2Ds.get(n);
    }

    private void computeBoundingBox() {
        this.min = new double[2];
        this.max = new double[2];
        this.min[0] = AbstractPolygon2D.min(this.x);
        this.max[0] = AbstractPolygon2D.max(this.x);
        this.min[1] = AbstractPolygon2D.min(this.y);
        this.max[1] = AbstractPolygon2D.max(this.y);
    }

    private static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public boolean roughContainsPoint2D(Point2D point2D) {
        if (this.max == null || this.min == null) {
            this.computeBoundingBox();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        return !(d < this.min[0] || d > this.max[0] || d2 < this.min[1]) && !(d2 > this.max[1]);
    }

    public abstract double getProbability(Point2D var1, boolean var2);

    public abstract double getLogProbability(Point2D var1, boolean var2);

    public boolean containsPoint2D(Point2D point2D) {
        if (TRY_ROUGH && !this.roughContainsPoint2D(point2D)) {
            return false;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        boolean bl = false;
        int n = 0;
        int n2 = this.length - 1;
        while (n < this.length) {
            if ((this.y[n] <= d2 && d2 < this.y[n2] || this.y[n2] <= d2 && d2 < this.y[n]) && d < (this.x[n2] - this.x[n]) * (d2 - this.y[n]) / (this.y[n2] - this.y[n]) + this.x[n]) {
                bl = !bl;
            }
            n2 = n++;
        }
        return bl;
    }

    public boolean bordersPoint2D(Point2D point2D) {
        boolean bl = false;
        Iterator<Point2D> iterator = this.point2Ds.iterator();
        for (int i = 0; i < this.length; ++i) {
            Point2D point2D2 = iterator.next();
            if (!point2D2.equals(point2D)) continue;
            bl = true;
        }
        return bl;
    }

    public void transformByMapping(CartogramMapping cartogramMapping) {
        for (int i = 0; i < this.length + 1; ++i) {
            this.point2Ds.set(i, cartogramMapping.map(this.point2Ds.get(i)));
        }
        this.convertPointsToArrays();
    }

    public void swapXYs() {
        for (int i = 0; i < this.length + 1; ++i) {
            this.point2Ds.set(i, new Point2D.Double(this.point2Ds.get(i).getY(), this.point2Ds.get(i).getX()));
        }
        this.convertPointsToArrays();
    }

    public void rescale(double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.length + 1; ++i) {
            this.point2Ds.set(i, new Point2D.Double((this.point2Ds.get(i).getX() - d) * (d3 / d2), (d4 - this.point2Ds.get(i).getY()) * (d6 / d5)));
        }
        this.convertPointsToArrays();
    }

    public void rescaleToPositiveCoordinates() {
        double[][] dArray = this.getXYMinMax();
        double d = 0.0;
        double d2 = 0.0;
        if (dArray[0][0] < 0.0) {
            d = -dArray[0][0];
        }
        if (dArray[1][0] < 0.0) {
            d2 = -dArray[1][0];
        }
        if (d < 0.0 || d2 < 0.0) {
            for (int i = 0; i < this.length + 1; ++i) {
                this.point2Ds.set(i, new Point2D.Double(this.point2Ds.get(i).getX() + d, this.point2Ds.get(i).getY() + d2));
            }
            this.convertPointsToArrays();
        }
    }

    public double[][] getXYMinMax() {
        Object object;
        if (this.minMax == null) {
            object = new int[this.x.length];
            int[] nArray = new int[this.y.length];
            HeapSort.sort(this.x, (int[])object);
            HeapSort.sort(this.y, nArray);
            this.minMax = new double[2][2];
            this.minMax[0][0] = this.x[object[0]];
            this.minMax[0][1] = this.x[object[((double[][])object).length - 1]];
            this.minMax[1][0] = this.y[nArray[0]];
            this.minMax[1][1] = this.y[nArray[nArray.length - 1]];
        }
        object = new double[2][2];
        object[0][0] = this.minMax[0][0];
        object[0][1] = this.minMax[0][1];
        object[1][0] = this.minMax[1][0];
        object[1][1] = this.minMax[1][1];
        return object;
    }

    public double calculateArea() {
        double d = 0.0;
        for (int i = 0; i < this.length; ++i) {
            d += this.x[i] * this.y[i + 1] - this.x[i + 1] * this.y[i];
        }
        return Math.abs(d / 2.0);
    }

    public Point2D getCentroid() {
        Point2D.Double double_ = new Point2D.Double();
        double d = this.calculateArea();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d4 = this.x[i] * this.y[i + 1] - this.x[i + 1] * this.y[i];
            d2 += this.x[i] * this.x[i + 1] * d4;
            d3 += this.y[i] * this.y[i + 1] * d4;
        }
        double d5 = 1.0 / (d * 6.0);
        ((Point2D)double_).setLocation(d2 *= d5, d3 *= d5);
        System.out.println("centroid = " + d2 + "," + d3);
        return double_;
    }

    private static LinkedList<Point2D> getCirclePoints(double d, double d2, int n, double d3) {
        LinkedList<Point2D> linkedList = new LinkedList<Point2D>();
        double d4 = Math.toRadians(d);
        double d5 = Math.toRadians(d2);
        double d6 = d3 / 6378137.0;
        for (int i = 0; i <= n; ++i) {
            double d7 = 360.0 / (double)n;
            double d8 = Math.toRadians((double)i * d7);
            double d9 = Math.asin(Math.sin(d4) * Math.cos(d6) + Math.cos(d4) * Math.sin(d6) * Math.cos(d8));
            double d10 = Math.atan2(Math.sin(d8) * Math.sin(d6) * Math.cos(d4), Math.cos(d6) - Math.sin(d4) * Math.sin(d9));
            double d11 = (d5 + d10 + Math.PI) % (Math.PI * 2) - Math.PI;
            linkedList.add(new Point2D.Double(Math.toDegrees(d9), Math.toDegrees(d11)));
        }
        return linkedList;
    }

    protected static boolean isInsideClip(Point2D point2D, Side side, Rectangle2D rectangle2D) {
        if (side == Side.top) {
            return point2D.getY() <= rectangle2D.getMaxY();
        }
        if (side == Side.bottom) {
            return point2D.getY() >= rectangle2D.getMinY();
        }
        if (side == Side.left) {
            return point2D.getX() >= rectangle2D.getMinX();
        }
        if (side == Side.right) {
            return point2D.getX() <= rectangle2D.getMaxX();
        }
        throw new RuntimeException("Error in Polygon");
    }

    protected static Point2D intersectionPoint2D(Side side, Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D) {
        if (side == Side.top) {
            double d = rectangle2D.getMaxY();
            return new Point2D.Double(point2D.getX() + (d - point2D.getY()) * (point2D2.getX() - point2D.getX()) / (point2D2.getY() - point2D.getY()), d);
        }
        if (side == Side.bottom) {
            double d = rectangle2D.getMinY();
            return new Point2D.Double(point2D.getX() + (d - point2D.getY()) * (point2D2.getX() - point2D.getX()) / (point2D2.getY() - point2D.getY()), d);
        }
        if (side == Side.right) {
            double d = rectangle2D.getMaxX();
            return new Point2D.Double(d, point2D.getY() + (d - point2D.getX()) * (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX()));
        }
        if (side == Side.left) {
            double d = rectangle2D.getMinX();
            return new Point2D.Double(d, point2D.getY() + (d - point2D.getX()) * (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX()));
        }
        return null;
    }

    public AbstractPolygon2D clip(Rectangle2D rectangle2D) {
        LinkedList<Point2D> linkedList = new LinkedList<Point2D>();
        LinkedList<Point2D> linkedList2 = new LinkedList<Point2D>(this.point2Ds);
        for (Side side : Side.values()) {
            linkedList.clear();
            for (int i = 0; i < linkedList2.size() - 1; ++i) {
                Point2D point2D = linkedList2.get(i);
                Point2D point2D2 = linkedList2.get(i + 1);
                if (AbstractPolygon2D.isInsideClip(point2D, side, rectangle2D)) {
                    if (AbstractPolygon2D.isInsideClip(point2D2, side, rectangle2D)) {
                        linkedList.add(point2D2);
                        continue;
                    }
                    linkedList.add(AbstractPolygon2D.intersectionPoint2D(side, point2D, point2D2, rectangle2D));
                    continue;
                }
                if (!AbstractPolygon2D.isInsideClip(point2D2, side, rectangle2D)) continue;
                linkedList.add(AbstractPolygon2D.intersectionPoint2D(side, point2D, point2D2, rectangle2D));
                linkedList.add(point2D2);
            }
            if (!linkedList.getFirst().equals(linkedList.getLast())) {
                linkedList.add(linkedList.getFirst());
            }
            linkedList2 = new LinkedList<Point2D>(linkedList);
        }
        new Polygon2DFactory();
        return Polygon2DFactory.createPolygon2D(linkedList, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(POLYGON).append("[\n");
        for (Point2D point2D : this.point2Ds) {
            stringBuffer.append("\t");
            stringBuffer.append(point2D);
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract void setFillValue(double var1);

    public abstract double getFillValue();

    public abstract double getLogFillValue();

    public abstract boolean hasFillValue();

    public double getLength() {
        return this.length;
    }

    public static void readKMLElement(Element element, List<AbstractPolygon2D> list) {
        if (element.getName().equalsIgnoreCase(POLYGON)) {
            new Polygon2DFactory();
            AbstractPolygon2D abstractPolygon2D = Polygon2DFactory.createPolygon2D(element);
            list.add(abstractPolygon2D);
        } else {
            for (Object e : element.getChildren()) {
                if (!(e instanceof Element)) continue;
                AbstractPolygon2D.readKMLElement((Element)e, list);
            }
        }
    }

    public static List<AbstractPolygon2D> readKMLFile(String string) {
        ArrayList<AbstractPolygon2D> arrayList = new ArrayList<AbstractPolygon2D>();
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setValidation(false);
            sAXBuilder.setIgnoringElementContentWhitespace(true);
            Document document = sAXBuilder.build(new File(string));
            Element element = document.getRootElement();
            if (!element.getName().equalsIgnoreCase("KML")) {
                throw new RuntimeException("Not a KML file");
            }
            AbstractPolygon2D.readKMLElement(element, arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        return arrayList;
    }

    protected static enum Side {
        left,
        right,
        top,
        bottom;

    }
}

