/*
 * Decompiled with CFR 0.152.
 */
package core.lattice;

import core.lattice.LatticeNode;
import java.util.BitSet;

public class Lattice {
    private LatticeNode all;
    private LatticeNode[] singleNodes;
    private int nbVariables;
    private int nbInstances;

    public Lattice(int nbVariables, int nbInstances, int[] nbValuesForAttribute, BitSet[][] convData) {
        this.nbVariables = nbVariables;
        this.nbInstances = nbInstances;
        this.singleNodes = new LatticeNode[nbVariables];
        this.all = new LatticeNode(this, nbValuesForAttribute);
        int a = 0;
        while (a < nbVariables) {
            LatticeNode node;
            int[] variablesNumbers = new int[]{a};
            this.singleNodes[a] = node = new LatticeNode(this, variablesNumbers, nbValuesForAttribute, convData[a], this.all);
            ++a;
        }
    }

    public int getNbVariables() {
        return this.nbVariables;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public LatticeNode getAll() {
        return this.all;
    }

    public LatticeNode[] getSingleNodes() {
        return this.singleNodes;
    }

    public LatticeNode getNode(BitSet clique) {
        int[] variables = new int[clique.cardinality()];
        int current = 0;
        int i = clique.nextSetBit(0);
        while (i >= 0) {
            variables[current] = i;
            ++current;
            i = clique.nextSetBit(i + 1);
        }
        return this.getNode(variables);
    }

    public LatticeNode getNode(int[] variables) {
        LatticeNode node = this.singleNodes[variables[0]];
        int i = 1;
        while (i < variables.length) {
            node = node.getChild(variables[i], this);
            ++i;
        }
        return node;
    }

    protected BitSet getSetForVariable(int variableIndex, int valueIndex) {
        return this.singleNodes[variableIndex].getSet(valueIndex);
    }
}

