/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.VerticalBox;
import org.scilab.forge.jlatexmath.VlineAtom;

public class MatrixAtom
extends Atom {
    public static SpaceAtom hsep = new SpaceAtom(0, 1.0f, 0.0f, 0.0f);
    public static SpaceAtom semihsep = new SpaceAtom(0, 0.5f, 0.0f, 0.0f);
    public static SpaceAtom vsep_in = new SpaceAtom(1, 0.0f, 1.0f, 0.0f);
    public static SpaceAtom vsep_ext_top = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    public static SpaceAtom vsep_ext_bot = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    public static final int ARRAY = 0;
    public static final int MATRIX = 1;
    public static final int ALIGN = 2;
    public static final int ALIGNAT = 3;
    public static final int FLALIGN = 4;
    public static final int SMALLMATRIX = 5;
    public static final int ALIGNED = 6;
    public static final int ALIGNEDAT = 7;
    private static final Box nullBox = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    private ArrayOfAtoms matrix;
    private int[] position;
    private Map<Integer, VlineAtom> vlines = new HashMap<Integer, VlineAtom>();
    private boolean isAlign;
    private boolean isAlignat;
    private boolean isFl;
    private int type;
    private boolean isPartial;
    private boolean spaceAround;
    private static SpaceAtom align = new SpaceAtom(2);

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, String options, boolean spaceAround) {
        this.isPartial = isPartial;
        this.matrix = array;
        this.type = 0;
        this.spaceAround = spaceAround;
        this.parsePositions(new StringBuffer(options));
    }

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, String options) {
        this(isPartial, array, options, false);
    }

    public MatrixAtom(ArrayOfAtoms array, String options) {
        this(false, array, options);
    }

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, int type) {
        this(isPartial, array, type, false);
    }

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, int type, boolean spaceAround) {
        this.isPartial = isPartial;
        this.matrix = array;
        this.type = type;
        this.spaceAround = spaceAround;
        if (type != 1 && type != 5) {
            this.position = new int[this.matrix.col];
            for (int i = 0; i < this.matrix.col; i += 2) {
                this.position[i] = 1;
                if (i + 1 >= this.matrix.col) continue;
                this.position[i + 1] = 0;
            }
        } else {
            this.position = new int[this.matrix.col];
            for (int i = 0; i < this.matrix.col; ++i) {
                this.position[i] = 2;
            }
        }
    }

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, int type, int alignment) {
        this(isPartial, array, type, alignment, true);
    }

    public MatrixAtom(boolean isPartial, ArrayOfAtoms array, int type, int alignment, boolean spaceAround) {
        this.isPartial = isPartial;
        this.matrix = array;
        this.type = type;
        this.spaceAround = spaceAround;
        this.position = new int[this.matrix.col];
        for (int i = 0; i < this.matrix.col; ++i) {
            this.position[i] = alignment;
        }
    }

    public MatrixAtom(ArrayOfAtoms array, int type) {
        this(false, array, type);
    }

    private void parsePositions(StringBuffer opt) {
        int len = opt.length();
        ArrayList<Integer> lposition = new ArrayList<Integer>();
        block9: for (int pos = 0; pos < len; ++pos) {
            char ch = opt.charAt(pos);
            switch (ch) {
                case 'l': {
                    lposition.add(0);
                    continue block9;
                }
                case 'r': {
                    lposition.add(1);
                    continue block9;
                }
                case 'c': {
                    lposition.add(2);
                    continue block9;
                }
                case '|': {
                    int nb = 1;
                    while (++pos < len) {
                        ch = opt.charAt(pos);
                        if (ch != '|') {
                            --pos;
                            break;
                        }
                        ++nb;
                    }
                    this.vlines.put(lposition.size(), new VlineAtom(nb));
                    continue block9;
                }
                case '@': {
                    TeXFormula tf = new TeXFormula();
                    TeXParser tp = new TeXParser(this.isPartial, opt.substring(++pos), tf, false);
                    Atom at = tp.getArgument();
                    ++this.matrix.col;
                    for (int j = 0; j < this.matrix.row; ++j) {
                        this.matrix.array.get(j).add(lposition.size(), at);
                    }
                    lposition.add(5);
                    pos += tp.getPos();
                    --pos;
                    continue block9;
                }
                case '*': {
                    TeXFormula tf = new TeXFormula();
                    TeXParser tp = new TeXParser(this.isPartial, opt.substring(++pos), tf, false);
                    String[] args = tp.getOptsArgs(2, 0);
                    pos += tp.getPos();
                    int nrep = Integer.parseInt(args[1]);
                    String str = "";
                    for (int j = 0; j < nrep; ++j) {
                        str = str + args[2];
                    }
                    opt.insert(pos, str);
                    len = opt.length();
                    --pos;
                    continue block9;
                }
                case '\t': 
                case ' ': {
                    continue block9;
                }
                default: {
                    lposition.add(2);
                }
            }
        }
        for (int j = lposition.size(); j < this.matrix.col; ++j) {
            lposition.add(2);
        }
        if (lposition.size() != 0) {
            Integer[] tab = lposition.toArray(new Integer[0]);
            this.position = new int[tab.length];
            for (int i = 0; i < tab.length; ++i) {
                this.position[i] = tab[i];
            }
        } else {
            this.position = new int[]{2};
        }
    }

    public Box[] getColumnSep(TeXEnvironment env, float width) {
        int row = this.matrix.row;
        int col = this.matrix.col;
        Box[] arr = new Box[col + 1];
        float w = env.getTextwidth();
        if (this.type == 6 || this.type == 7) {
            w = Float.POSITIVE_INFINITY;
        }
        switch (this.type) {
            case 0: {
                int i = 1;
                if (this.position[0] == 5) {
                    arr[1] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                    i = 2;
                }
                arr[0] = this.spaceAround ? semihsep.createBox(env) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                arr[col] = arr[0];
                Box Hsep = hsep.createBox(env);
                while (i < col) {
                    if (this.position[i] == 5) {
                        arr[i] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                        arr[i + 1] = arr[i];
                        ++i;
                    } else {
                        arr[i] = Hsep;
                    }
                    ++i;
                }
                return arr;
            }
            case 1: 
            case 5: {
                arr[0] = nullBox;
                arr[col] = arr[0];
                Box Hsep = hsep.createBox(env);
                for (int i = 1; i < col; ++i) {
                    arr[i] = Hsep;
                }
                return arr;
            }
            case 2: 
            case 6: {
                Box AlignSep;
                Box Align = align.createBox(env);
                if (w != Float.POSITIVE_INFINITY) {
                    float h = Math.max((w - width - (float)(col / 2) * Align.getWidth()) / (float)Math.floor((col + 3) / 2), 0.0f);
                    AlignSep = new StrutBox(h, 0.0f, 0.0f, 0.0f);
                } else {
                    AlignSep = hsep.createBox(env);
                }
                arr[col] = AlignSep;
                for (int i = 0; i < col; ++i) {
                    arr[i] = i % 2 == 0 ? AlignSep : Align;
                }
                break;
            }
            case 3: 
            case 7: {
                float h = w != Float.POSITIVE_INFINITY ? Math.max((w - width) / 2.0f, 0.0f) : 0.0f;
                Box Align = align.createBox(env);
                Box empty = nullBox;
                arr[0] = new StrutBox(h, 0.0f, 0.0f, 0.0f);
                arr[col] = arr[0];
                for (int i = 1; i < col; ++i) {
                    arr[i] = i % 2 == 0 ? empty : Align;
                }
                break;
            }
            case 4: {
                Box AlignSep;
                Box Align = align.createBox(env);
                if (w != Float.POSITIVE_INFINITY) {
                    float h = Math.max((w - width - (float)(col / 2) * Align.getWidth()) / (float)Math.floor((col - 1) / 2), 0.0f);
                    AlignSep = new StrutBox(h, 0.0f, 0.0f, 0.0f);
                } else {
                    AlignSep = hsep.createBox(env);
                }
                arr[0] = nullBox;
                arr[col] = arr[0];
                for (int i = 1; i < col; ++i) {
                    arr[i] = i % 2 == 0 ? AlignSep : Align;
                }
                break;
            }
        }
        if (w == Float.POSITIVE_INFINITY) {
            arr[0] = nullBox;
            arr[col] = arr[0];
        }
        return arr;
    }

    public Box createBox(TeXEnvironment env) {
        int j;
        int i;
        int row = this.matrix.row;
        int col = this.matrix.col;
        Box[][] boxarr = new Box[row][col];
        float[] lineDepth = new float[row];
        float[] lineHeight = new float[row];
        float[] rowWidth = new float[col];
        float matW = 0.0f;
        float drt = env.getTeXFont().getDefaultRuleThickness(env.getStyle());
        if (this.type == 5) {
            env = env.copy();
            env.setStyle(4);
        }
        ArrayList<MulticolumnAtom> listMulti = new ArrayList<MulticolumnAtom>();
        for (i = 0; i < row; ++i) {
            lineDepth[i] = 0.0f;
            lineHeight[i] = 0.0f;
            for (int j2 = 0; j2 < col; ++j2) {
                Atom at = null;
                try {
                    at = this.matrix.array.get(i).get(j2);
                }
                catch (Exception e) {
                    boxarr[i][j2 - 1].type = 11;
                    j2 = col - 1;
                }
                boxarr[i][j2] = at == null ? nullBox : at.createBox(env);
                lineDepth[i] = Math.max(boxarr[i][j2].getDepth(), lineDepth[i]);
                lineHeight[i] = Math.max(boxarr[i][j2].getHeight(), lineHeight[i]);
                if (boxarr[i][j2].type != 12) {
                    rowWidth[j2] = Math.max(boxarr[i][j2].getWidth(), rowWidth[j2]);
                    continue;
                }
                ((MulticolumnAtom)at).setRowColumn(i, j2);
                listMulti.add((MulticolumnAtom)at);
            }
        }
        for (i = 0; i < listMulti.size(); ++i) {
            MulticolumnAtom multi = (MulticolumnAtom)listMulti.get(i);
            int c = multi.getCol();
            int r = multi.getRow();
            int n = multi.getSkipped();
            float w = 0.0f;
            for (int j3 = c; j3 < c + n; ++j3) {
                w += rowWidth[j3];
            }
            if (!(boxarr[r][c].getWidth() > w)) continue;
            float extraW = (boxarr[r][c].getWidth() - w) / (float)n;
            j = c;
            while (j < c + n) {
                int n2 = j++;
                rowWidth[n2] = rowWidth[n2] + extraW;
            }
        }
        for (int j4 = 0; j4 < col; ++j4) {
            matW += rowWidth[j4];
        }
        Box[] Hsep = this.getColumnSep(env, matW);
        for (int j5 = 0; j5 < col + 1; ++j5) {
            matW += Hsep[j5].getWidth();
            if (this.vlines.get(j5) == null) continue;
            matW += this.vlines.get(j5).getWidth(env);
        }
        VerticalBox vb = new VerticalBox();
        Box Vsep = vsep_in.createBox(env);
        vb.add(vsep_ext_top.createBox(env));
        float vsepH = Vsep.getHeight();
        float totalHeight = 0.0f;
        for (int i2 = 0; i2 < row; ++i2) {
            HorizontalBox hb = new HorizontalBox();
            block15: for (j = 0; j < col; ++j) {
                switch (boxarr[i2][j].type) {
                    case -1: 
                    case 12: {
                        if (j == 0) {
                            if (this.vlines.get(0) != null) {
                                VlineAtom vat = this.vlines.get(0);
                                vat.setHeight(lineHeight[i2] + lineDepth[i2] + Vsep.getHeight());
                                vat.setShift(lineDepth[i2] + Vsep.getHeight() / 2.0f);
                                Box vatBox = vat.createBox(env);
                                hb.add(new HorizontalBox(vatBox, Hsep[0].getWidth() + vatBox.getWidth(), 0));
                            } else {
                                hb.add(Hsep[0]);
                            }
                        }
                        boolean lastVline = true;
                        if (boxarr[i2][j].type == -1) {
                            hb.add(new HorizontalBox(boxarr[i2][j], rowWidth[j], this.position[j]));
                        } else {
                            Box b = this.generateMulticolumn(env, Hsep, rowWidth, i2, j);
                            MulticolumnAtom matom = (MulticolumnAtom)this.matrix.array.get(i2).get(j);
                            j += matom.getSkipped() - 1;
                            hb.add(b);
                            lastVline = matom.hasRightVline();
                        }
                        if (lastVline && this.vlines.get(j + 1) != null) {
                            VlineAtom vat = this.vlines.get(j + 1);
                            vat.setHeight(lineHeight[i2] + lineDepth[i2] + Vsep.getHeight());
                            vat.setShift(lineDepth[i2] + Vsep.getHeight() / 2.0f);
                            Box vatBox = vat.createBox(env);
                            if (j < col - 1) {
                                hb.add(new HorizontalBox(vatBox, Hsep[j + 1].getWidth() + vatBox.getWidth(), 2));
                                continue block15;
                            }
                            hb.add(new HorizontalBox(vatBox, Hsep[j + 1].getWidth() + vatBox.getWidth(), 1));
                            continue block15;
                        }
                        hb.add(Hsep[j + 1]);
                        continue block15;
                    }
                    case 11: {
                        float f = env.getTextwidth();
                        f = f == Float.POSITIVE_INFINITY ? rowWidth[j] : f;
                        hb = new HorizontalBox(boxarr[i2][j], f, 0);
                        j = col - 1;
                        continue block15;
                    }
                    case 13: {
                        HlineAtom at = (HlineAtom)this.matrix.array.get(i2).get(j);
                        at.setWidth(matW);
                        if (i2 >= 1 && this.matrix.array.get(i2 - 1).get(j) instanceof HlineAtom) {
                            hb.add(new StrutBox(0.0f, 2.0f * drt, 0.0f, 0.0f));
                            at.setShift(-Vsep.getHeight() / 2.0f + drt);
                        } else {
                            at.setShift(-Vsep.getHeight() / 2.0f);
                        }
                        hb.add(at.createBox(env));
                        j = col;
                    }
                }
            }
            if (boxarr[i2][0].type != 13) {
                hb.setHeight(lineHeight[i2]);
                hb.setDepth(lineDepth[i2]);
                vb.add(hb);
                if (i2 >= row - 1) continue;
                vb.add(Vsep);
                continue;
            }
            vb.add(hb);
        }
        vb.add(vsep_ext_bot.createBox(env));
        totalHeight = vb.getHeight() + vb.getDepth();
        float axis = env.getTeXFont().getAxisHeight(env.getStyle());
        vb.setHeight(totalHeight / 2.0f + axis);
        vb.setDepth(totalHeight / 2.0f - axis);
        return vb;
    }

    private Box generateMulticolumn(TeXEnvironment env, Box[] Hsep, float[] rowWidth, int i, int j) {
        int k;
        float w = 0.0f;
        MulticolumnAtom mca = (MulticolumnAtom)this.matrix.array.get(i).get(j);
        int n = mca.getSkipped();
        for (k = j; k < j + n - 1; ++k) {
            w += rowWidth[k] + Hsep[k + 1].getWidth();
            if (this.vlines.get(k + 1) == null) continue;
            w += this.vlines.get(k + 1).getWidth(env);
        }
        w += rowWidth[k];
        Box b = mca.createBox(env);
        float bw = b.getWidth();
        if (bw > w) {
            w = 0.0f;
        }
        mca.setWidth(w);
        b = mca.createBox(env);
        return b;
    }
}

