/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.csparsej.tfloat.Scs_add;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_cumsum;
import edu.emory.mathcs.csparsej.tfloat.Scs_dropzeros;
import edu.emory.mathcs.csparsej.tfloat.Scs_dupl;
import edu.emory.mathcs.csparsej.tfloat.Scs_multiply;
import edu.emory.mathcs.csparsej.tfloat.Scs_transpose;
import edu.emory.mathcs.csparsej.tfloat.Scs_util;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Scs_common.Scs scs;
    protected boolean rowIndexesSorted;

    public SparseCCFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray[0].length);
        this.assign(fArray);
    }

    public SparseCCFloatMatrix2D(Scs_common.Scs scs) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(scs.m, scs.n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.scs = scs;
    }

    public SparseCCFloatMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCFloatMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.scs = Scs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
    }

    public SparseCCFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float f, boolean bl, boolean bl2) {
        block9: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (f == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n3 = Math.max(nArray.length, 1);
        this.scs = Scs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
        int[] nArray3 = new int[n2];
        int[] nArray4 = this.scs.p;
        int[] nArray5 = this.scs.i;
        float[] fArray = this.scs.x;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray2[i];
            nArray3[n4] = nArray3[n4] + 1;
        }
        Scs_cumsum.cs_cumsum((int[])nArray4, (int[])nArray3, (int)n2);
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray2[i];
            nArray3[n5] = nArray3[n5] + 1;
            nArray5[i] = nArray[i];
            if (fArray == null) continue;
            fArray[i] = f;
        }
        if (bl && !Scs_dupl.cs_dupl((Scs_common.Scs)this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (bl2) {
            this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
            this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
            if (this.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public SparseCCFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray, boolean bl, boolean bl2, boolean bl3) {
        block10: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block10;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != fArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n3 = Math.max(nArray.length, 1);
        this.scs = Scs_util.cs_spalloc((int)n, (int)n2, (int)n3, (boolean)true, (boolean)false);
        int[] nArray3 = new int[n2];
        int[] nArray4 = this.scs.p;
        int[] nArray5 = this.scs.i;
        float[] fArray2 = this.scs.x;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray2[i];
            nArray3[n4] = nArray3[n4] + 1;
        }
        Scs_cumsum.cs_cumsum((int[])nArray4, (int[])nArray3, (int)n2);
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray2[i];
            nArray3[n5] = nArray3[n5] + 1;
            nArray5[i] = nArray[i];
            if (fArray2 == null) continue;
            fArray2[i] = fArray[i];
        }
        if (bl2) {
            Scs_dropzeros.cs_dropzeros((Scs_common.Scs)this.scs);
        }
        if (bl && !Scs_dupl.cs_dupl((Scs_common.Scs)this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (bl3) {
            this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
            this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
            if (this.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
            if (f != f) {
                return this.assign(f);
            }
            float[] fArray = this.scs.x;
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] * f;
            }
        } else {
            this.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    return floatFunction.apply(f);
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(float f) {
        if (f == 0.0f) {
            Arrays.fill(this.scs.i, 0);
            Arrays.fill(this.scs.p, 0);
            Arrays.fill(this.scs.x, 0.0f);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.scs.x[i] = f;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof SparseCCFloatMatrix2D) {
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D = (SparseCCFloatMatrix2D)floatMatrix2D;
            System.arraycopy(sparseCCFloatMatrix2D.getColumnPointers(), 0, this.scs.p, 0, this.columns + 1);
            int n = sparseCCFloatMatrix2D.getRowIndexes().length;
            if (this.scs.nzmax < n) {
                this.scs.i = new int[n];
                this.scs.x = new float[n];
            }
            System.arraycopy(sparseCCFloatMatrix2D.getRowIndexes(), 0, this.scs.i, 0, n);
            System.arraycopy(sparseCCFloatMatrix2D.getValues(), 0, this.scs.x, 0, n);
            this.rowIndexesSorted = sparseCCFloatMatrix2D.rowIndexesSorted;
        } else if (floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D = ((SparseRCFloatMatrix2D)floatMatrix2D).getTranspose();
            this.scs.p = sparseRCFloatMatrix2D.getRowPointers();
            this.scs.i = sparseRCFloatMatrix2D.getColumnIndexes();
            this.scs.x = sparseRCFloatMatrix2D.getValues();
            this.scs.nzmax = this.scs.x.length;
            this.rowIndexesSorted = true;
        } else {
            this.assign(0.0f);
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    SparseCCFloatMatrix2D.this.setQuick(n, n2, f);
                    return f;
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof SparseCCFloatMatrix2D && floatFloatFunction == FloatFunctions.plus) {
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D = (SparseCCFloatMatrix2D)floatMatrix2D;
            this.scs = Scs_add.cs_add((Scs_common.Scs)this.scs, (Scs_common.Scs)sparseCCFloatMatrix2D.scs, (float)1.0f, (float)1.0f);
            return this;
        }
        if (floatFloatFunction instanceof FloatPlusMultSecond) {
            final float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    SparseCCFloatMatrix2D.this.setQuick(n, n2, SparseCCFloatMatrix2D.this.getQuick(n, n2) + f * f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction instanceof FloatPlusMultFirst) {
            final float f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this.assign(floatMatrix2D);
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    SparseCCFloatMatrix2D.this.setQuick(n, n2, f * SparseCCFloatMatrix2D.this.getQuick(n, n2) + f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction == FloatFunctions.mult) {
            int[] nArray = this.scs.i;
            int[] nArray2 = this.scs.p;
            float[] fArray = this.scs.x;
            int n = this.columns;
            while (--n >= 0) {
                int n2 = nArray2[n];
                int n3 = nArray2[n + 1];
                while (--n3 >= n2) {
                    int n4 = nArray[n3];
                    int n5 = n3;
                    fArray[n5] = fArray[n5] * floatMatrix2D.getQuick(n4, n);
                    if (fArray[n3] != 0.0f) continue;
                    this.remove(n4, n);
                }
            }
            return this;
        }
        if (floatFloatFunction == FloatFunctions.div) {
            int[] nArray = this.scs.i;
            int[] nArray3 = this.scs.p;
            float[] fArray = this.scs.x;
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray3[n];
                int n7 = nArray3[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = n7;
                    fArray[n9] = fArray[n9] / floatMatrix2D.getQuick(n8, n);
                    if (fArray[n7] != 0.0f) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        return super.assign(floatMatrix2D, floatFloatFunction);
    }

    public int cardinality() {
        return this.scs.p[this.columns];
    }

    public Scs_common.Scs elements() {
        return this.scs;
    }

    public FloatMatrix2D forEachNonZero(IntIntFloatFunction intIntFloatFunction) {
        int[] nArray = this.scs.i;
        int[] nArray2 = this.scs.p;
        float[] fArray = this.scs.x;
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                float f;
                int n4 = nArray[n3];
                float f2 = fArray[n3];
                fArray[n3] = f = intIntFloatFunction.apply(n4, n, f2);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.scs.p;
    }

    public DenseFloatMatrix2D getDense() {
        final DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFloatFunction(){

            public float apply(int n, int n2, float f) {
                denseFloatMatrix2D.setQuick(n, n2, SparseCCFloatMatrix2D.this.getQuick(n, n2));
                return f;
            }
        });
        return denseFloatMatrix2D;
    }

    public synchronized float getQuick(int n, int n2) {
        int n3 = SparseCCFloatMatrix2D.searchFromTo(this.scs.i, n, this.scs.p[n2], this.scs.p[n2 + 1] - 1);
        float f = 0.0f;
        if (n3 >= 0) {
            f = this.scs.x[n3];
        }
        return f;
    }

    public SparseRCFloatMatrix2D getRowCompressed() {
        Scs_common.Scs scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D = new SparseRCFloatMatrix2D(this.rows, this.columns);
        sparseRCFloatMatrix2D.columnIndexes = scs.i;
        sparseRCFloatMatrix2D.rowPointers = scs.p;
        sparseRCFloatMatrix2D.values = scs.x;
        sparseRCFloatMatrix2D.columnIndexesSorted = true;
        return sparseRCFloatMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.scs.i;
    }

    public SparseCCFloatMatrix2D getTranspose() {
        Scs_common.Scs scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
        SparseCCFloatMatrix2D sparseCCFloatMatrix2D = new SparseCCFloatMatrix2D(this.columns, this.rows);
        sparseCCFloatMatrix2D.scs = scs;
        return sparseCCFloatMatrix2D;
    }

    public float[] getValues() {
        return this.scs.x;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseCCFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, float f) {
        int n3 = SparseCCFloatMatrix2D.searchFromTo(this.scs.i, n, this.scs.p[n2], this.scs.p[n2 + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f) {
                this.remove(n2, n3);
            } else {
                this.scs.x[n3] = f;
            }
            return;
        }
        if (f != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f);
        }
    }

    public void sortRowIndexes() {
        this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
        this.scs = Scs_transpose.cs_transpose((Scs_common.Scs)this.scs, (boolean)true);
        if (this.scs == null) {
            throw new IllegalArgumentException("Exception occured in cs_transpose()!");
        }
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        if (!Scs_dupl.cs_dupl((Scs_common.Scs)this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
    }

    public void removeZeroes() {
        Scs_dropzeros.cs_dropzeros((Scs_common.Scs)this.scs);
    }

    public void trimToSize() {
        Scs_util.cs_sprealloc((Scs_common.Scs)this.scs, (int)0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.scs.p[i + 1];
            for (int j = this.scs.p[i]; j < n; ++j) {
                stringBuilder.append('(').append(this.scs.i[j]).append(',').append(i).append(')').append('\t').append(this.scs.x[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = floatMatrix1D2 == null || bl;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if ((long)n2 != floatMatrix1D.size() || (long)n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        final float[] fArray = denseFloatMatrix1D.elements;
        final int n3 = denseFloatMatrix1D.stride();
        final int n4 = (int)denseFloatMatrix1D.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        final float[] fArray2 = denseFloatMatrix1D2.elements;
        final int n5 = denseFloatMatrix1D2.stride();
        final int n6 = (int)denseFloatMatrix1D2.index(0);
        final int[] nArray = this.scs.i;
        final int[] nArray2 = this.scs.p;
        final float[] fArray3 = this.scs.x;
        int n7 = n4;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!bl2 && (double)(f2 / f) != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f2 / f));
            }
            if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n9;
                int n10;
                n8 = 2;
                Future[] futureArray = new Future[n8];
                final float[] fArray4 = new float[n];
                int n11 = this.columns / n8;
                for (n10 = 0; n10 < n8; ++n10) {
                    n9 = n10 * n11;
                    final int n12 = n10 == n8 - 1 ? this.columns : n9 + n11;
                    final int n13 = n10;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n13 == 0) {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    float f = fArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n2 = nArray[j];
                                        int n32 = n4 + n3 * n2;
                                        fArray[n32] = fArray[n32] + fArray3[j] * f;
                                    }
                                }
                            } else {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    float f = fArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = nArray[j];
                                        fArray4[n52] = fArray4[n52] + fArray3[j] * f;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n9 = n10 = n % 10; n9 < n; n9 += 10) {
                    int n14 = n4 + n9 * n3;
                    fArray[n14] = fArray[n14] + fArray4[n9];
                    int n15 = n4 + (n9 + 1) * n3;
                    fArray[n15] = fArray[n15] + fArray4[n9 + 1];
                    int n16 = n4 + (n9 + 2) * n3;
                    fArray[n16] = fArray[n16] + fArray4[n9 + 2];
                    int n17 = n4 + (n9 + 3) * n3;
                    fArray[n17] = fArray[n17] + fArray4[n9 + 3];
                    int n18 = n4 + (n9 + 4) * n3;
                    fArray[n18] = fArray[n18] + fArray4[n9 + 4];
                    int n19 = n4 + (n9 + 5) * n3;
                    fArray[n19] = fArray[n19] + fArray4[n9 + 5];
                    int n20 = n4 + (n9 + 6) * n3;
                    fArray[n20] = fArray[n20] + fArray4[n9 + 6];
                    int n21 = n4 + (n9 + 7) * n3;
                    fArray[n21] = fArray[n21] + fArray4[n9 + 7];
                    int n22 = n4 + (n9 + 8) * n3;
                    fArray[n22] = fArray[n22] + fArray4[n9 + 8];
                    int n23 = n4 + (n9 + 9) * n3;
                    fArray[n23] = fArray[n23] + fArray4[n9 + 9];
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    int n24 = n4 + n9 * n3;
                    fArray[n24] = fArray[n24] + fArray4[n9];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n25 = nArray2[i + 1];
                    float f3 = fArray2[n6 + n5 * i];
                    for (int j = nArray2[i]; j < n25; ++j) {
                        int n26 = nArray[j];
                        int n27 = n4 + n3 * n26;
                        fArray[n27] = fArray[n27] + fArray3[j] * f3;
                    }
                }
            }
            if ((double)f != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f));
            }
        } else if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n28 = this.columns / n8;
            for (int i = 0; i < n8; ++i) {
                final int n29 = i * n28;
                final int n30 = i == n8 - 1 ? this.columns : n29 + n28;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n29 * n3;
                        int n2 = SparseCCFloatMatrix2D.this.scs.p[n29];
                        for (int i = n29; i < n30; ++i) {
                            float f3 = 0.0f;
                            int n32 = SparseCCFloatMatrix2D.this.scs.p[i + 1];
                            while (n2 + 10 < n32) {
                                int n42 = n2 + 9;
                                f3 += fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]] + fArray3[n42] * fArray2[n6 + n5 * SparseCCFloatMatrix2D.this.scs.i[n42--]];
                                n2 += 10;
                            }
                            while (n2 < n32) {
                                f3 += fArray3[n2] * fArray2[SparseCCFloatMatrix2D.this.scs.i[n2]];
                                ++n2;
                            }
                            fArray[n] = f * f3 + f2 * fArray[n];
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n31 = this.scs.p[0];
            for (int i = 0; i < this.columns; ++i) {
                float f4 = 0.0f;
                int n32 = this.scs.p[i + 1];
                while (n31 + 10 < n32) {
                    int n33 = n31 + 9;
                    f4 += fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]] + fArray3[n33] * fArray2[n6 + n5 * this.scs.i[n33--]];
                    n31 += 10;
                }
                while (n31 < n32) {
                    f4 += fArray3[n31] * fArray2[this.scs.i[n31]];
                    ++n31;
                }
                fArray[n7] = f * f4 + f2 * fArray[n7];
                n7 += n3;
            }
        }
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = floatMatrix2D.rows();
        int n4 = floatMatrix2D.columns();
        if (bl2) {
            n3 = floatMatrix2D.columns();
            n4 = floatMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = floatMatrix2D2 == null;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = floatMatrix2D instanceof SparseCCFloatMatrix2D ? new SparseCCFloatMatrix2D(n, n5, n * n5) : new DenseFloatMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)f2 != 1.0) {
            floatMatrix2D2.assign(FloatFunctions.mult(f2));
        }
        if (floatMatrix2D instanceof DenseFloatMatrix2D && floatMatrix2D2 instanceof DenseFloatMatrix2D) {
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D = bl ? this.getTranspose() : this;
            DenseFloatMatrix2D denseFloatMatrix2D = bl2 ? (DenseFloatMatrix2D)floatMatrix2D.viewDice() : (DenseFloatMatrix2D)floatMatrix2D;
            DenseFloatMatrix2D denseFloatMatrix2D2 = (DenseFloatMatrix2D)floatMatrix2D2;
            int[] nArray = sparseCCFloatMatrix2D.scs.p;
            int[] nArray2 = sparseCCFloatMatrix2D.scs.i;
            float[] fArray = sparseCCFloatMatrix2D.scs.x;
            int n6 = (int)denseFloatMatrix2D.index(0, 0);
            int n7 = denseFloatMatrix2D.rowStride();
            int n8 = denseFloatMatrix2D.columnStride();
            float[] fArray2 = denseFloatMatrix2D.elements;
            int n9 = (int)denseFloatMatrix2D2.index(0, 0);
            int n10 = denseFloatMatrix2D2.rowStride();
            int n11 = denseFloatMatrix2D2.columnStride();
            float[] fArray3 = denseFloatMatrix2D2.elements;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n12 = nArray[j + 1];
                    float f3 = fArray2[n6 + j * n7 + i * n8];
                    for (int k = nArray[j]; k < n12; ++k) {
                        int n13 = nArray2[k];
                        int n14 = n9 + n13 * n10 + i * n11;
                        fArray3[n14] = fArray3[n14] + fArray[k] * f3;
                    }
                }
            }
            if ((double)f != 1.0) {
                floatMatrix2D2.assign(FloatFunctions.mult(f));
            }
        } else if (floatMatrix2D instanceof SparseCCFloatMatrix2D && floatMatrix2D2 instanceof SparseCCFloatMatrix2D) {
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D = bl ? this.getTranspose() : this;
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D2 = (SparseCCFloatMatrix2D)floatMatrix2D;
            if (bl2) {
                sparseCCFloatMatrix2D2 = sparseCCFloatMatrix2D2.getTranspose();
            }
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D3 = (SparseCCFloatMatrix2D)floatMatrix2D2;
            sparseCCFloatMatrix2D3.scs = Scs_multiply.cs_multiply((Scs_common.Scs)sparseCCFloatMatrix2D.scs, (Scs_common.Scs)sparseCCFloatMatrix2D2.scs);
            if (sparseCCFloatMatrix2D3.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_multiply()");
            }
            if ((double)f != 1.0) {
                sparseCCFloatMatrix2D3.assign(FloatFunctions.mult(f));
            }
        } else {
            if (bl2) {
                floatMatrix2D = floatMatrix2D.viewDice();
            }
            FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
            int n15 = n2;
            while (--n15 >= 0) {
                floatMatrix1DArray[n15] = floatMatrix2D.viewRow(n15);
            }
            FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[n];
            int n16 = n;
            while (--n16 >= 0) {
                floatMatrix1DArray2[n16] = floatMatrix2D2.viewRow(n16);
            }
            FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
            int[] nArray = this.scs.i;
            int[] nArray3 = this.scs.p;
            float[] fArray = this.scs.x;
            int n17 = this.columns;
            while (--n17 >= 0) {
                int n18 = nArray3[n17];
                int n19 = nArray3[n17 + 1];
                while (--n19 >= n18) {
                    int n20 = nArray[n19];
                    floatPlusMultSecond.multiplicator = fArray[n19] * f;
                    if (!bl) {
                        floatMatrix1DArray2[n20].assign(floatMatrix1DArray[n17], floatPlusMultSecond);
                        continue;
                    }
                    floatMatrix1DArray2[n17].assign(floatMatrix1DArray[n20], floatPlusMultSecond);
                }
            }
        }
        return floatMatrix2D2;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, float f) {
        IntArrayList intArrayList = new IntArrayList(this.scs.i);
        intArrayList.setSizeRaw(this.scs.p[this.columns]);
        FloatArrayList floatArrayList = new FloatArrayList(this.scs.x);
        floatArrayList.setSizeRaw(this.scs.p[this.columns]);
        intArrayList.beforeInsert(n3, n);
        floatArrayList.beforeInsert(n3, f);
        int n4 = this.scs.p.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.scs.p[n5] = this.scs.p[n5] + 1;
        }
        this.scs.i = intArrayList.elements();
        this.scs.x = floatArrayList.elements();
        this.scs.nzmax = intArrayList.elements().length;
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.scs.i);
        FloatArrayList floatArrayList = new FloatArrayList(this.scs.x);
        intArrayList.remove(n2);
        floatArrayList.remove(n2);
        int n3 = this.scs.p.length;
        while (--n3 > n) {
            int n4 = n3;
            this.scs.p[n4] = this.scs.p[n4] - 1;
        }
        this.scs.i = intArrayList.elements();
        this.scs.x = floatArrayList.elements();
        this.scs.nzmax = intArrayList.elements().length;
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }
}

