/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.stack;

import com.sosnoski.util.stack.StackBase;

public class IntStack
extends StackBase {
    protected int[] m_baseArray;

    public IntStack(int n, int n2) {
        super(n, n2, Integer.TYPE);
    }

    public IntStack(int n) {
        super(n, Integer.TYPE);
    }

    public IntStack() {
        this(8);
    }

    public IntStack(IntStack intStack) {
        super(intStack);
    }

    protected Object getArray() {
        return this.m_baseArray;
    }

    protected void setArray(Object object) {
        this.m_baseArray = (int[])object;
    }

    public void push(int n) {
        int n2 = this.getAddIndex();
        this.m_baseArray[n2] = n;
    }

    public int pop() {
        if (this.m_countPresent > 0) {
            return this.m_baseArray[--this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public int pop(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= n) {
            this.m_countPresent -= n;
            return this.m_baseArray[this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public int peek(int n) {
        if (this.m_countPresent > n) {
            return this.m_baseArray[this.m_countPresent - n - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public int peek() {
        return this.peek(0);
    }

    public int[] toArray() {
        return (int[])this.buildArray(Integer.TYPE);
    }

    public Object clone() {
        return new IntStack(this);
    }
}

