/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import com.sosnoski.util.hashset.IntHashSet;
import com.sosnoski.util.queue.IntQueue;
import java.util.Iterator;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadthFirstSearchIterator
implements Iterator<Integer> {
    protected Graph graph = null;
    protected IntQueue q = new IntQueue();
    protected IntHashSet visited = new IntHashSet();
    protected Integer distance = null;

    public BreadthFirstSearchIterator(Graph graph, int seedNode) {
        this.graph = graph;
        this.q.add(seedNode);
        this.q.add(0);
    }

    public BreadthFirstSearchIterator(Graph graph, int seedNode, int[] subset) {
        this(graph, seedNode);
        if (subset != null) {
            this.restrictToSubgraph(subset);
        }
    }

    public Integer getDistance() {
        return this.distance;
    }

    @Override
    public boolean hasNext() {
        return !this.q.isEmpty();
    }

    @Override
    public Integer next() {
        Integer result = this.q.remove();
        this.distance = this.q.remove();
        int[] neighbors = this.graph.getAdjacentNodeIndicesArray(result, Directedness.OUT);
        this.visited.add(result);
        for (int neighbor : neighbors) {
            if (this.visited.contains(neighbor)) continue;
            this.q.add(neighbor);
            this.q.add(this.distance + 1);
            this.visited.add(neighbor);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void restrictToSubgraph(int[] subset) {
        int i;
        IntHashSet s = new IntHashSet();
        int n = this.graph.getNodeCount();
        for (i = 0; i < subset.length; ++i) {
            s.add(subset[i]);
        }
        this.visited.clear();
        for (i = 0; i < n; ++i) {
            if (s.contains(i)) continue;
            this.visited.add(i);
        }
    }
}

