/*
 * Decompiled with CFR 0.152.
 */
package jd2.datatypes;

import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.datatypes.TsInformationType;
import jd2.datatypes.TsMoniker;
import lombok.NonNull;

public final class Ts {
    @NonNull
    private final TsMoniker moniker;
    @NonNull
    private final TsInformationType type;
    private final String name;
    @NonNull
    private final Map<String, String> metaData;
    private final TsData data;

    Ts(@NonNull TsMoniker moniker, @NonNull TsInformationType type, String name, @NonNull Map<String, String> metaData, TsData data) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        this.moniker = moniker;
        this.type = type;
        this.name = name;
        this.metaData = metaData;
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().moniker(this.moniker).type(this.type).name(this.name).data(this.data);
        if (this.metaData != null) {
            builder.metaData(this.metaData);
        }
        return builder;
    }

    @NonNull
    public TsMoniker getMoniker() {
        return this.moniker;
    }

    @NonNull
    public TsInformationType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @NonNull
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public TsData getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ts)) {
            return false;
        }
        Ts other = (Ts)o;
        TsMoniker this$moniker = this.getMoniker();
        TsMoniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !((Object)this$moniker).equals(other$moniker)) {
            return false;
        }
        TsInformationType this$type = this.getType();
        TsInformationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        TsData this$data = this.getData();
        TsData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TsMoniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : ((Object)$moniker).hashCode());
        TsInformationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        TsData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Ts(moniker=" + this.getMoniker() + ", type=" + this.getType() + ", name=" + this.getName() + ", metaData=" + this.getMetaData() + ", data=" + this.getData() + ")";
    }

    public static class Builder {
        private TsMoniker moniker;
        private TsInformationType type;
        private String name;
        private ArrayList<String> metaData$key;
        private ArrayList<String> metaData$value;
        private TsData data;

        public TsMoniker getMoniker() {
            return this.moniker;
        }

        public TsInformationType getType() {
            return this.type;
        }

        Builder() {
        }

        public Builder moniker(@NonNull TsMoniker moniker) {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.moniker = moniker;
            return this;
        }

        public Builder type(@NonNull TsInformationType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder meta(String metaKey, String metaValue) {
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            this.metaData$key.add(metaKey);
            this.metaData$value.add(metaValue);
            return this;
        }

        public Builder metaData(Map<? extends String, ? extends String> metaData) {
            if (metaData == null) {
                throw new NullPointerException("metaData cannot be null");
            }
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metaData.entrySet()) {
                this.metaData$key.add($lombokEntry.getKey());
                this.metaData$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public Builder clearMetaData() {
            if (this.metaData$key != null) {
                this.metaData$key.clear();
                this.metaData$value.clear();
            }
            return this;
        }

        public Builder data(TsData data) {
            this.data = data;
            return this;
        }

        public Ts build() {
            Map<String, String> metaData;
            switch (this.metaData$key == null ? 0 : this.metaData$key.size()) {
                case 0: {
                    metaData = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metaData = Collections.singletonMap(this.metaData$key.get(0), this.metaData$value.get(0));
                    break;
                }
                default: {
                    metaData = new LinkedHashMap(this.metaData$key.size() < 0x40000000 ? 1 + this.metaData$key.size() + (this.metaData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metaData$key.size(); ++$i) {
                        metaData.put(this.metaData$key.get($i), this.metaData$value.get($i));
                    }
                    metaData = Collections.unmodifiableMap(metaData);
                }
            }
            return new Ts(this.moniker, this.type, this.name, metaData, this.data);
        }

        public String toString() {
            return "Ts.Builder(moniker=" + this.moniker + ", type=" + this.type + ", name=" + this.name + ", metaData$key=" + this.metaData$key + ", metaData$value=" + this.metaData$value + ", data=" + this.data + ")";
        }
    }
}

