/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.MolGridDepiction;
import org.openscience.cdk.depict.ReactionDepiction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.SymbolVisibility;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.standard.SelectionVisibility;
import org.openscience.cdk.renderer.generators.standard.StandardGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class DepictionGenerator {
    private static final Color[] KELLY_MAX_CONTRAST = new Color[]{new Color(21386), new Color(9677312), new Color(12648480), new Color(16757504), new Color(32052), new Color(16738304), new Color(13541986), new Color(8482918), new Color(10927575), new Color(8404597), new Color(16152206), new Color(16743004), new Color(5453690), new Color(16748032), new Color(11741265), new Color(16041984), new Color(8329229), new Color(5845781), new Color(15809043), new Color(2305046)};
    public static final double AUTOMATIC = -1.0;
    public static final double DEFAULT_MM_MARGIN = 0.56;
    public static final double DEFAULT_PX_MARGIN = 4.0;
    private Dimensions dimensions = Dimensions.AUTOMATIC;
    private final Map<Class<? extends IGeneratorParameter>, IGeneratorParameter<?>> params = new HashMap();
    private final Font font;
    private final List<IGenerator<IAtomContainer>> gens = new ArrayList<IGenerator<IAtomContainer>>();
    private boolean annotateAtomNum = false;
    private boolean annotateAtomVal = false;
    private boolean annotateAtomMap = false;
    private boolean highlightAtomMap = false;
    private Color[] atomMapColors = null;
    private boolean alignMappedReactions = true;
    private final Map<IChemObject, Color> highlight = new HashMap<IChemObject, Color>();

    public DepictionGenerator() {
        this(new Font(DepictionGenerator.getDefaultOsFont(), 0, 13));
        this.setParam(BasicSceneGenerator.BondLength.class, 26.1);
        this.setParam(StandardGenerator.HashSpacing.class, 3.25);
        this.setParam(StandardGenerator.WaveSpacing.class, 3.25);
    }

    public DepictionGenerator(Font font) {
        this.gens.add((IGenerator<IAtomContainer>)new BasicSceneGenerator());
        this.font = font;
        this.gens.add((IGenerator<IAtomContainer>)new StandardGenerator(this.font));
        for (IGenerator<IAtomContainer> gen : this.gens) {
            for (IGeneratorParameter param : gen.getParameters()) {
                this.params.put(param.getClass(), param);
            }
        }
        for (IGeneratorParameter param : new RendererModel().getRenderingParameters()) {
            this.params.put(param.getClass(), param);
        }
        this.setParam(BasicSceneGenerator.Margin.class, -1.0);
        this.setParam(RendererModel.Padding.class, -1.0);
    }

    private DepictionGenerator(DepictionGenerator org) {
        this.annotateAtomMap = org.annotateAtomMap;
        this.annotateAtomVal = org.annotateAtomVal;
        this.annotateAtomNum = org.annotateAtomNum;
        this.highlightAtomMap = org.highlightAtomMap;
        this.atomMapColors = org.atomMapColors;
        this.dimensions = org.dimensions;
        this.font = org.font;
        this.highlight.putAll(org.highlight);
        this.gens.addAll(org.gens);
        this.params.putAll(org.params);
        this.alignMappedReactions = org.alignMappedReactions;
    }

    private <U, T extends IGeneratorParameter<U>> U getParameterValue(Class<T> key) {
        IGeneratorParameter<?> param = this.params.get(key);
        if (param == null) {
            throw new IllegalArgumentException("No parameter registered: " + key + " " + this.params.keySet());
        }
        return (U)param.getValue();
    }

    private <T extends IGeneratorParameter<S>, S, U extends S> void setParam(Class<T> key, U val) {
        try {
            IGeneratorParameter param = (IGeneratorParameter)key.newInstance();
            param.setValue(val);
            this.params.put(key, param);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggingToolFactory.createLoggingTool(this.getClass()).error((Object)("Could not copy rendering parameter: " + key));
        }
    }

    private RendererModel getModel() {
        RendererModel model = new RendererModel();
        for (IGenerator<IAtomContainer> iGenerator : this.gens) {
            model.registerParameters(iGenerator);
        }
        for (IGeneratorParameter iGeneratorParameter : this.params.values()) {
            model.set(iGeneratorParameter.getClass(), iGeneratorParameter.getValue());
        }
        return model;
    }

    public Depiction depict(IAtomContainer mol) throws CDKException {
        return this.depict(Collections.singleton(mol), 1, 1);
    }

    public Depiction depict(Iterable<IAtomContainer> mols) throws CDKException {
        int count = (int)StreamSupport.stream(mols.spliterator(), false).count();
        Dimension grid = Dimensions.determineGrid(count);
        return this.depict(mols, grid.height, grid.width);
    }

    public Depiction depict(Iterable<IAtomContainer> mols, int nrow, int ncol) throws CDKException {
        ArrayList<LayoutBackup> layoutBackups = new ArrayList<LayoutBackup>();
        int molId = 0;
        for (IAtomContainer iAtomContainer : mols) {
            if (iAtomContainer == null) {
                throw new NullPointerException("Null molecule provided!");
            }
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.ID_KEY, "mol" + ++molId);
            layoutBackups.add(new LayoutBackup(iAtomContainer));
        }
        this.prepareCoords(mols);
        for (Map.Entry entry : this.highlight.entrySet()) {
            ((IChemObject)entry.getKey()).setProperty((Object)"stdgen.highlight.color", entry.getValue());
        }
        ArrayList<IAtomContainer> molList = new ArrayList<IAtomContainer>();
        mols.forEach(molList::add);
        DepictionGenerator depictionGenerator = this.withParam(BasicSceneGenerator.Scale.class, this.caclModelScale(molList));
        RendererModel model = depictionGenerator.getModel();
        List<Bounds> molElems = depictionGenerator.generate(molList, model, 1);
        for (LayoutBackup backup : layoutBackups) {
            backup.reset();
        }
        ArrayList<Bounds> titles = new ArrayList<Bounds>();
        if (((Boolean)depictionGenerator.getParameterValue(BasicSceneGenerator.ShowMoleculeTitle.class)).booleanValue()) {
            for (IAtomContainer mol : mols) {
                titles.add(depictionGenerator.generateTitle((IChemObject)mol, (Double)model.get(BasicSceneGenerator.Scale.class)));
            }
        }
        for (IChemObject obj : this.highlight.keySet()) {
            obj.removeProperty((Object)"stdgen.highlight.color");
        }
        this.highlight.clear();
        return new MolGridDepiction(model, molElems, titles, this.dimensions, nrow, ncol);
    }

    private void prepareCoords(Iterable<IAtomContainer> mols) throws CDKException {
        for (IAtomContainer mol : mols) {
            if (this.ensure2dLayout(mol) || mol.getBondCount() <= 0) continue;
            double factor = GeometryUtil.getScaleFactor((IAtomContainer)mol, (double)1.5);
            GeometryUtil.scaleMolecule((IAtomContainer)mol, (double)factor);
        }
    }

    private static void setIfMissing(IChemObject chemObject, String key, String val) {
        if (chemObject.getProperty((Object)key) == null) {
            chemObject.setProperty((Object)key, (Object)val);
        }
    }

    public Depiction depict(IReaction rxn) throws CDKException {
        this.ensure2dLayout(rxn);
        Color fgcol = ((IAtomColorer)this.getParameterValue(StandardGenerator.AtomColor.class)).getAtomColor((IAtom)rxn.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        List<IAtomContainer> reactants = this.toList(rxn.getReactants());
        List<IAtomContainer> products = this.toList(rxn.getProducts());
        List<IAtomContainer> agents = this.toList(rxn.getAgents());
        ArrayList<LayoutBackup> layoutBackups = new ArrayList<LayoutBackup>();
        int molId = 0;
        for (IAtomContainer iAtomContainer : reactants) {
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.CLASS_KEY, "reactant");
            layoutBackups.add(new LayoutBackup(iAtomContainer));
        }
        for (IAtomContainer iAtomContainer : products) {
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.CLASS_KEY, "product");
            layoutBackups.add(new LayoutBackup(iAtomContainer));
        }
        for (IAtomContainer iAtomContainer : agents) {
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing((IChemObject)iAtomContainer, MarkedElement.CLASS_KEY, "agent");
            layoutBackups.add(new LayoutBackup(iAtomContainer));
        }
        HashMap<IChemObject, Color> myHighlight = new HashMap<IChemObject, Color>();
        if (this.highlightAtomMap) {
            myHighlight.putAll(this.makeHighlightAtomMap(reactants, products));
        }
        myHighlight.putAll(this.highlight);
        this.highlight.clear();
        this.prepareCoords(reactants);
        this.prepareCoords(products);
        this.prepareCoords(agents);
        for (Map.Entry entry : myHighlight.entrySet()) {
            ((IChemObject)entry.getKey()).setProperty((Object)"stdgen.highlight.color", entry.getValue());
        }
        double d = this.caclModelScale(rxn);
        DepictionGenerator copy = this.withParam(BasicSceneGenerator.Scale.class, d);
        RendererModel model = copy.getModel();
        List<Bounds> reactantBounds = copy.generate(reactants, model, 1);
        List<Bounds> productBounds = copy.generate(this.toList(rxn.getProducts()), model, rxn.getReactantCount());
        List<Bounds> agentBounds = copy.generate(this.toList(rxn.getAgents()), model, rxn.getReactantCount() + rxn.getProductCount());
        for (Object obj : myHighlight.keySet()) {
            obj.removeProperty((Object)"stdgen.highlight.color");
        }
        Bounds plus = copy.generatePlusSymbol(d, fgcol);
        for (LayoutBackup backup : layoutBackups) {
            backup.reset();
        }
        Bounds emptyBounds = new Bounds();
        Bounds title = (Boolean)copy.getParameterValue(BasicSceneGenerator.ShowReactionTitle.class) != false ? copy.generateTitle((IChemObject)rxn, d) : emptyBounds;
        ArrayList<Bounds> reactantTitles = new ArrayList<Bounds>();
        ArrayList<Bounds> productTitles = new ArrayList<Bounds>();
        if (((Boolean)copy.getParameterValue(BasicSceneGenerator.ShowMoleculeTitle.class)).booleanValue()) {
            for (IAtomContainer reactant : reactants) {
                reactantTitles.add(copy.generateTitle((IChemObject)reactant, d));
            }
            for (IAtomContainer product : products) {
                productTitles.add(copy.generateTitle((IChemObject)product, d));
            }
        }
        Bounds conditions = this.generateReactionConditions(rxn, fgcol, (Double)model.get(BasicSceneGenerator.Scale.class));
        return new ReactionDepiction(model, reactantBounds, productBounds, agentBounds, plus, rxn.getDirection(), this.dimensions, reactantTitles, productTitles, title, conditions, fgcol);
    }

    private Map<IChemObject, Color> makeHighlightAtomMap(List<IAtomContainer> reactants, List<IAtomContainer> products) {
        HashSet<Integer> reactantMapIdxs = new HashSet<Integer>();
        HashSet<Integer> productMapIdxs = new HashSet<Integer>();
        for (IAtomContainer mol : reactants) {
            for (IAtom atom : mol.atoms()) {
                reactantMapIdxs.add(this.accessAtomMap(atom));
            }
        }
        for (IAtomContainer mol : products) {
            for (IAtom atom : mol.atoms()) {
                productMapIdxs.add(this.accessAtomMap(atom));
            }
        }
        HashMap<IChemObject, Color> colorMap = new HashMap<IChemObject, Color>();
        HashMap<Integer, Color> mapToColor = new HashMap<Integer, Color>();
        TreeMap<Integer, IAtom> amap = new TreeMap<Integer, IAtom>();
        int colorIdx = -1;
        for (IAtomContainer mol : reactants) {
            int prevPalletIdx = colorIdx;
            for (IAtom atom : mol.atoms()) {
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0 || !productMapIdxs.contains(mapidx)) continue;
                if (prevPalletIdx == colorIdx && ++colorIdx >= this.atomMapColors.length) {
                    throw new IllegalArgumentException("Not enough colors to highlight atom mapping, please provide mode");
                }
                Color color = this.atomMapColors[colorIdx];
                colorMap.put((IChemObject)atom, color);
                mapToColor.put(mapidx, color);
                amap.put(mapidx, atom);
            }
            if (colorIdx <= prevPalletIdx) continue;
            for (IBond bond : mol.bonds()) {
                IAtom a1 = bond.getBegin();
                IAtom a2 = bond.getEnd();
                Color c1 = (Color)colorMap.get(a1);
                Color c2 = (Color)colorMap.get(a2);
                if (c1 == null || c1 != c2) continue;
                colorMap.put((IChemObject)bond, c1);
            }
        }
        for (IAtomContainer mol : products) {
            for (IAtom atom : mol.atoms()) {
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0 || !reactantMapIdxs.contains(mapidx)) continue;
                colorMap.put((IChemObject)atom, (Color)mapToColor.get(mapidx));
            }
            for (IBond pBnd : mol.bonds()) {
                IAtom pBeg = pBnd.getBegin();
                IAtom pEnd = pBnd.getEnd();
                Color c1 = (Color)colorMap.get(pBeg);
                Color c2 = (Color)colorMap.get(pEnd);
                if (c1 == null || c1 != c2) continue;
                IAtom rBeg = (IAtom)amap.get(this.accessAtomMap(pBeg));
                IAtom rEnd = (IAtom)amap.get(this.accessAtomMap(pEnd));
                if (rBeg == null || rEnd == null) continue;
                IBond rBnd = rBeg.getBond(rEnd);
                if (rBnd != null && (pBnd.isAromatic() && rBnd.isAromatic() || rBnd.getOrder() == pBnd.getOrder())) {
                    colorMap.put((IChemObject)pBnd, c1);
                    continue;
                }
                colorMap.remove(rBnd);
            }
        }
        return colorMap;
    }

    private Integer accessAtomMap(IAtom atom) {
        Integer mapidx = (Integer)atom.getProperty((Object)"cdk:AtomAtomMapping", Integer.class);
        if (mapidx == null) {
            return 0;
        }
        return mapidx;
    }

    private Bounds generatePlusSymbol(double scale, Color fgcol) {
        return new Bounds(StandardGenerator.embedText((Font)this.font, (String)"+", (Color)fgcol, (double)(1.0 / scale)));
    }

    private List<IAtomContainer> toList(IAtomContainerSet set) {
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        set.atomContainers().forEach(mols::add);
        return mols;
    }

    private IRenderingElement generate(IAtomContainer molecule, RendererModel model, int atomNum) throws CDKException {
        String molId = (String)molecule.getProperty((Object)MarkedElement.ID_KEY);
        if (molId != null) {
            int atomId = 0;
            int bondid = 0;
            for (IAtom atom : molecule.atoms()) {
                DepictionGenerator.setIfMissing((IChemObject)atom, MarkedElement.ID_KEY, molId + "atm" + ++atomId);
            }
            for (IBond bond : molecule.bonds()) {
                DepictionGenerator.setIfMissing((IChemObject)bond, MarkedElement.ID_KEY, molId + "bnd" + ++bondid);
            }
        }
        if (this.annotateAtomNum) {
            for (IAtom atom : molecule.atoms()) {
                if (atom.getProperty((Object)"stdgen.annotation.label") != null) {
                    throw new UnsupportedOperationException("Multiple annotation labels are not supported.");
                }
                atom.setProperty((Object)"stdgen.annotation.label", (Object)Integer.toString(atomNum++));
            }
        } else if (this.annotateAtomVal) {
            for (IAtom atom : molecule.atoms()) {
                if (atom.getProperty((Object)"stdgen.annotation.label") != null) {
                    throw new UnsupportedOperationException("Multiple annotation labels are not supported.");
                }
                atom.setProperty((Object)"stdgen.annotation.label", atom.getProperty((Object)"cdk:Comment"));
            }
        } else if (this.annotateAtomMap) {
            for (IAtom atom : molecule.atoms()) {
                if (atom.getProperty((Object)"stdgen.annotation.label") != null) {
                    throw new UnsupportedOperationException("Multiple annotation labels are not supported.");
                }
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0) continue;
                atom.setProperty((Object)"stdgen.annotation.label", (Object)Integer.toString(mapidx));
            }
        }
        ElementGroup grp = new ElementGroup();
        for (IGenerator<IAtomContainer> gen : this.gens) {
            grp.add(gen.generate((IChemObject)molecule, model));
        }
        if (this.annotateAtomNum || this.annotateAtomMap) {
            for (IAtom atom : molecule.atoms()) {
                atom.removeProperty((Object)"stdgen.annotation.label");
            }
        }
        return grp;
    }

    private List<Bounds> generate(List<IAtomContainer> mols, RendererModel model, int atomNum) throws CDKException {
        ArrayList<Bounds> elems = new ArrayList<Bounds>();
        boolean num = false;
        for (IAtomContainer mol : mols) {
            elems.add(new Bounds(this.generate(mol, model, atomNum)));
            atomNum += mol.getAtomCount();
        }
        return elems;
    }

    private Bounds generateTitle(IChemObject chemObj, double scale) {
        String title = (String)chemObj.getProperty((Object)"cdk:Title");
        if (title == null || title.isEmpty()) {
            return new Bounds();
        }
        scale = 1.0 / scale * (Double)this.getParameterValue(RendererModel.TitleFontScale.class);
        return new Bounds((IRenderingElement)MarkedElement.markup((IRenderingElement)StandardGenerator.embedText((Font)this.font, (String)title, (Color)((Color)this.getParameterValue(RendererModel.TitleColor.class)), (double)scale), (String[])new String[]{"title"}));
    }

    private Bounds generateReactionConditions(IReaction chemObj, Color fg, double scale) {
        String title = (String)chemObj.getProperty((Object)"cdk:ReactionConditions");
        if (title == null || title.isEmpty()) {
            return new Bounds();
        }
        return new Bounds((IRenderingElement)MarkedElement.markup((IRenderingElement)StandardGenerator.embedText((Font)this.font, (String)title, (Color)fg, (double)(1.0 / scale)), (String[])new String[]{"conditions"}));
    }

    private boolean ensure2dLayout(IAtomContainer container) throws CDKException {
        if (!GeometryUtil.has2DCoordinates((IAtomContainer)container)) {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.generateCoordinates(container);
            return true;
        }
        return false;
    }

    private void ensure2dLayout(IReaction rxn) throws CDKException {
        if (!GeometryUtil.has2DCoordinates((IReaction)rxn)) {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setAlignMappedReaction(this.alignMappedReactions);
            sdg.generateCoordinates(rxn);
        }
    }

    public DepictionGenerator withAtomColors() {
        return this.withAtomColors((IAtomColorer)new CDK2DAtomColors());
    }

    public DepictionGenerator withAtomColors(IAtomColorer colorer) {
        return this.withParam(StandardGenerator.AtomColor.class, colorer);
    }

    public DepictionGenerator withBackgroundColor(Color color) {
        return this.withParam(BasicSceneGenerator.BackgroundColor.class, color);
    }

    public DepictionGenerator withOuterGlowHighlight() {
        return this.withOuterGlowHighlight(4.0);
    }

    public DepictionGenerator withOuterGlowHighlight(double width) {
        return this.withParam(StandardGenerator.Highlighting.class, StandardGenerator.HighlightStyle.OuterGlow).withParam(StandardGenerator.OuterGlowWidth.class, width);
    }

    public DepictionGenerator withAtomNumbers() {
        if (this.annotateAtomMap || this.annotateAtomVal) {
            throw new IllegalArgumentException("Can not annotated atom numbers, atom values or maps are already annotated");
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.annotateAtomNum = true;
        return copy;
    }

    public DepictionGenerator withAtomValues() {
        if (this.annotateAtomNum || this.annotateAtomMap) {
            throw new IllegalArgumentException("Can not annotated atom values, atom numbers or maps are already annotated");
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.annotateAtomVal = true;
        return copy;
    }

    public DepictionGenerator withAtomMapNumbers() {
        if (this.annotateAtomNum) {
            throw new IllegalArgumentException("Can not annotated atom maps, atom numbers or values are already annotated");
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.annotateAtomMap = true;
        return copy;
    }

    public DepictionGenerator withAtomMapHighlight() {
        return this.withAtomMapHighlight(KELLY_MAX_CONTRAST);
    }

    public DepictionGenerator withAtomMapHighlight(Color[] colors) {
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.highlightAtomMap = true;
        copy.atomMapColors = Arrays.copyOf(colors, colors.length);
        return copy;
    }

    public DepictionGenerator withMolTitle() {
        return this.withParam(BasicSceneGenerator.ShowMoleculeTitle.class, true);
    }

    public DepictionGenerator withRxnTitle() {
        return this.withParam(BasicSceneGenerator.ShowReactionTitle.class, true);
    }

    public DepictionGenerator withMappedRxnAlign(boolean val) {
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.alignMappedReactions = val;
        return copy;
    }

    public DepictionGenerator withAnnotationColor(Color color) {
        return this.withParam(StandardGenerator.AnnotationColor.class, color);
    }

    public DepictionGenerator withAnnotationScale(double scale) {
        return this.withParam(StandardGenerator.AnnotationFontScale.class, scale);
    }

    public DepictionGenerator withTitleColor(Color color) {
        return this.withParam(RendererModel.TitleColor.class, color);
    }

    public DepictionGenerator withTitleScale(double scale) {
        return this.withParam(RendererModel.TitleFontScale.class, scale);
    }

    public DepictionGenerator withTerminalCarbons() {
        return this.withParam(StandardGenerator.Visibility.class, SelectionVisibility.disconnected((SymbolVisibility)SymbolVisibility.iupacRecommendations()));
    }

    public DepictionGenerator withCarbonSymbols() {
        return this.withParam(StandardGenerator.Visibility.class, SymbolVisibility.all());
    }

    public DepictionGenerator withHighlight(Iterable<? extends IChemObject> chemObjs, Color color) {
        DepictionGenerator copy = new DepictionGenerator(this);
        for (IChemObject iChemObject : chemObjs) {
            if (iChemObject instanceof IAtomContainer) {
                for (IAtom atom : ((IAtomContainer)iChemObject).atoms()) {
                    copy.highlight.put((IChemObject)atom, color);
                }
                for (IBond bond : ((IAtomContainer)iChemObject).bonds()) {
                    copy.highlight.put((IChemObject)bond, color);
                }
                continue;
            }
            copy.highlight.put(iChemObject, color);
        }
        return copy;
    }

    public DepictionGenerator withSize(double w, double h) {
        if (w < 0.0 && h >= 0.0 || h < 0.0 && w >= 0.0) {
            throw new IllegalArgumentException("Width and height must either both be automatic or both specified");
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.dimensions = w == -1.0 ? Dimensions.AUTOMATIC : new Dimensions(w, h);
        return copy;
    }

    public DepictionGenerator withMargin(double m) {
        return this.withParam(BasicSceneGenerator.Margin.class, m);
    }

    public DepictionGenerator withPadding(double p) {
        return this.withParam(RendererModel.Padding.class, p);
    }

    public DepictionGenerator withZoom(double zoom) {
        return this.withParam(BasicSceneGenerator.ZoomFactor.class, zoom);
    }

    public DepictionGenerator withFillToFit() {
        return this.withParam(BasicSceneGenerator.FitToScreen.class, true);
    }

    public DepictionGenerator withAromaticDisplay() {
        return this.withParam(StandardGenerator.ForceDelocalisedBondDisplay.class, true);
    }

    public DepictionGenerator withDeuteriumSymbol(boolean v) {
        return this.withParam(StandardGenerator.DeuteriumSymbol.class, v);
    }

    public <T extends IGeneratorParameter<S>, S, U extends S> DepictionGenerator withParam(Class<T> key, U value) {
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.setParam(key, value);
        return copy;
    }

    private double caclModelScale(Collection<IAtomContainer> mols) {
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (IAtomContainer mol : mols) {
            for (IBond bond : mol.bonds()) {
                bonds.add(bond);
            }
        }
        return this.calcModelScaleForBondLength(this.medianBondLength(bonds));
    }

    private double caclModelScale(IReaction rxn) {
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        for (IAtomContainer mol : rxn.getReactants().atomContainers()) {
            mols.add(mol);
        }
        for (IAtomContainer mol : rxn.getProducts().atomContainers()) {
            mols.add(mol);
        }
        for (IAtomContainer mol : rxn.getAgents().atomContainers()) {
            mols.add(mol);
        }
        return this.caclModelScale(mols);
    }

    private double medianBondLength(Collection<IBond> bonds) {
        if (bonds.isEmpty()) {
            return 1.5;
        }
        int nBonds = 0;
        double[] lengths = new double[bonds.size()];
        for (IBond bond : bonds) {
            Point2d p2;
            Point2d p1 = bond.getBegin().getPoint2d();
            if (p1.equals((Tuple2d)(p2 = bond.getEnd().getPoint2d()))) continue;
            lengths[nBonds++] = p1.distance(p2);
        }
        Arrays.sort(lengths, 0, nBonds);
        return lengths[nBonds / 2];
    }

    private double calcModelScaleForBondLength(double bondLength) {
        return (Double)this.getParameterValue(BasicSceneGenerator.BondLength.class) / bondLength;
    }

    private static String getDefaultOsFont() {
        return "SansSerif";
    }

    private static final class LayoutBackup {
        private final Point2d[] coords;
        private final IBond.Stereo[] btypes;
        private final IAtomContainer mol;

        public LayoutBackup(IAtomContainer mol) {
            int i;
            int numAtoms = mol.getAtomCount();
            int numBonds = mol.getBondCount();
            this.coords = new Point2d[numAtoms];
            this.btypes = new IBond.Stereo[numBonds];
            this.mol = mol;
            for (i = 0; i < numAtoms; ++i) {
                IAtom atom = mol.getAtom(i);
                this.coords[i] = atom.getPoint2d();
                if (this.coords[i] == null) continue;
                atom.setPoint2d(new Point2d(this.coords[i]));
            }
            for (i = 0; i < numBonds; ++i) {
                IBond bond = mol.getBond(i);
                this.btypes[i] = bond.getStereo();
            }
        }

        void reset() {
            int i;
            int numAtoms = this.mol.getAtomCount();
            int numBonds = this.mol.getBondCount();
            for (i = 0; i < numAtoms; ++i) {
                this.mol.getAtom(i).setPoint2d(this.coords[i]);
            }
            for (i = 0; i < numBonds; ++i) {
                this.mol.getBond(i).setStereo(this.btypes[i]);
            }
        }
    }
}

