/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cycles;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropCycle
extends Propagator<UndirectedGraphVar> {
    private final UndirectedGraphVar g;
    private final IGraphDeltaMonitor gdm;
    private final int n;
    private final IStateInt[] e1;
    private final IStateInt[] e2;
    private final IStateInt[] size;

    public PropCycle(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta(this);
        this.n = this.g.getNbMaxNodes();
        this.e1 = new IStateInt[this.n];
        this.e2 = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = graph.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.e1[i] = environment.makeInt(i);
            this.e2[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            if (this.g.getMandatoryNodes().size() > 1) {
                for (int i = 0; i < this.n; ++i) {
                    this.e1[i].set(i);
                    this.e2[i].set(i);
                    this.size[i].set(1);
                    this.g.removeEdge(i, i, this);
                }
            }
            for (int i = 0; i < this.n; ++i) {
                ISet nei = this.g.getMandatoryNeighborsOf(i);
                ISetIterator iSetIterator = nei.iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    if (i >= j) continue;
                    this.enforce(i, j);
                }
            }
            this.gdm.startMonitoring();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this::enforce, GraphEventType.ADD_EDGE);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public ESat isEntailed() {
        ISet nodes = this.g.getMandatoryNodes();
        if (this.g.isInstantiated() && nodes.size() == 1 && this.g.getMandatoryNeighborsOf(nodes.toArray()[0]).size() == 1) {
            return ESat.TRUE;
        }
        ISetIterator iSetIterator = nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryNeighborsOf(i).size() <= 2 && this.g.getPotentialNeighborsOf(i).size() >= 2) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void enforce(int i, int j) throws ContradictionException {
        int ext1 = this.getExt(i);
        int ext2 = this.getExt(j);
        int t = this.size[ext1].get() + this.size[ext2].get();
        this.setExt(ext1, ext2);
        this.setExt(ext2, ext1);
        this.size[ext1].set(t);
        this.size[ext2].set(t);
        if (t > 2) {
            if (t < this.g.getMandatoryNodes().size()) {
                this.g.removeEdge(ext1, ext2, this);
            } else if (this.g.getMandatoryNodes().size() == this.g.getPotentialNodes().size()) {
                this.g.enforceEdge(ext1, ext2, this);
            }
        }
    }

    private int getExt(int i) {
        return this.e1[i].get() == i ? this.e2[i].get() : this.e1[i].get();
    }

    private void setExt(int i, int ext) {
        if (this.e1[i].get() == i) {
            this.e2[i].set(ext);
        } else {
            this.e1[i].set(ext);
        }
    }
}

