% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_y_pai_sum}
\alias{compute_mh_y_pai_sum}
\title{Compute "NIH Toolbox - Positive Affect Items [Youth] (NA): Sum [Validation:
None missing or declined]"}
\usage{
compute_mh_y_pai_sum(
  data,
  name = "mh_y_pai_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_pai_sum}
NIH Toolbox - Positive Affect Items [Youth] (NA): Sum [Validation:
None missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_pai_001}
\item \code{mh_y_pai_002}
\item \code{mh_y_pai_003}
\item \code{mh_y_pai_004}
\item \code{mh_y_pai_005}
\item \code{mh_y_pai_006}
\item \code{mh_y_pai_007}
\item \code{mh_y_pai_008}
\item \code{mh_y_pai_009}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} none of 9 items missing
}
}
\examples{
\dontrun{
compute_mh_y_pai_sum(data) |>
  select(
    any_of(c("mh_y_pai_sum", vars_mh_y_pai))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_pai_nm]{compute_mh_y_pai_nm()}}
}
