% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\docType{data}
\name{vars_mh_y_pps__severity}
\alias{vars_mh_y_pps__severity}
\alias{compute_mh_y_pps__severity_nm}
\title{Compute "Prodromal Psychosis Scale [Youth] (Severity Score): Number
missing"}
\format{
vars_mh_y_pps__severity is a character vector of all column names
used to compute summary of \code{mh_y_pps__severity} scores.
}
\usage{
vars_mh_y_pps__severity

compute_mh_y_pps__severity_nm(
  data,
  name = "mh_y_pps__severity_nm",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\description{
Computes the summary score \code{mh_y_pps__severity_nm}
Prodromal Psychosis Scale [Youth] (Severity Score): Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_pps__severity_001}
\item \code{mh_y_pps__severity_002}
\item \code{mh_y_pps__severity_003}
\item \code{mh_y_pps__severity_004}
\item \code{mh_y_pps__severity_005}
\item \code{mh_y_pps__severity_006}
\item \code{mh_y_pps__severity_007}
\item \code{mh_y_pps__severity_008}
\item \code{mh_y_pps__severity_009}
\item \code{mh_y_pps__severity_010}
\item \code{mh_y_pps__severity_011}
\item \code{mh_y_pps__severity_012}
\item \code{mh_y_pps__severity_013}
\item \code{mh_y_pps__severity_014}
\item \code{mh_y_pps__severity_015}
\item \code{mh_y_pps__severity_016}
\item \code{mh_y_pps__severity_017}
\item \code{mh_y_pps__severity_018}
\item \code{mh_y_pps__severity_019}
\item \code{mh_y_pps__severity_020}
\item \code{mh_y_pps__severity_021}
}
\item \emph{Excluded values:} none
}
}
\details{
The number of missing values in the \code{mh_y_pps__severity} score is
calculated by subtracting the number of valid pairs from the total
\strong{bother} count for each subject
(mh_y_pps__bother_yes_count - severity_pair_good_sum).

A good pair is defined as a pair where the \code{mh_y_pps__bother__yes_count}
is 1 and the \code{mh_y_pps__severity} is not missing.
}
\examples{
\dontrun{
compute_mh_y_pps__severity_nm(data) |>
  select(
    any_of(c("mh_y_pps__severity_nm", vars_mh_y_pps__severity))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_pps__bother__yes_count]{compute_mh_y_pps__bother__yes_count()}}
}
\keyword{datasets}
