% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_initialisations.R
\name{create_matrix_parameter}
\alias{create_matrix_parameter}
\title{Make parameter matrix}
\usage{
create_matrix_parameter(BM, b0, bprey, bpred, E, T.K, T0, k)
}
\arguments{
\item{BM}{float vector, body mass of species.}

\item{b0}{const}

\item{bprey}{const}

\item{bpred}{const}

\item{E}{const}

\item{T.K, }{Celsius to Kelvin conversion}

\item{T0, }{Default temperature in Kelvin}

\item{k, }{Boltzmann constant}
}
\value{
A matrix filled with estimated values 
for a model parameter that depends on prey and predator body masses (see details)
}
\description{
Make parameter matrix
}
\details{
Make a parameter matrix that depends on both predators
and prey and that is used to define attack rates and handling
times based on the general allometric equation:
\deqn{p_{i,j} = b_0 * BM_i^{bprey} * BM_j^{bpred} * exp(-E * (T0-T.K) / (k * T.K * T0))}
}
