% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bubble_plot.R
\name{get_bubble_plot}
\alias{get_bubble_plot}
\title{Basketball bubble plot}
\usage{
get_bubble_plot(df_stats, player, descr_stats, size_text, size_text_x, size_legend)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{player}{Player.}

\item{descr_stats}{Description of the statistics for the legend.}

\item{size_text}{Text size inside each box.}

\item{size_text_x}{Stats labels size.}

\item{size_legend}{Legend size.}
}
\value{
Graphical device.
}
\description{
This plot is a representation of the percentiles of all statistics 
for a particular player. The figure shows four cells. The first box 
contains the percentiles between 0 and 24. The second, between 25 and 49. 
The third, between 50 and 74 and the fourth, between 75 and 100. The
percentiles are computed with the function 
\code{\link[Anthropometry]{percentilsArchetypoid}}.
Boxes of the same percentile category are in the same color in the interests
of easy understanding.

This type of visualization allows the user to analyze each player in a very 
simple way, since a general idea of those aspects of the game in which the 
player excels can be obtained.
}
\details{
In the example shown below, it can be seen that Alberto Abalde has a percentile of 
x in free throws percentage. This means that the x percent of league players has a fewer 
percentage than him, while there is a (100-x) percent who has a bigger percentage.
}
\examples{
\dontrun{
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)

df1 <- do_add_adv_stats(df)

df2 <- do_stats(df1, "Total", "2017-2018", compet, "Regular Season")

# When choosing a subset of stats, follow the order in which they appear
# in the data frame.
stats <- c("GP", "MP", "PTS", "FGA", "FGPerc", "ThreePA", "ThreePPerc", 
           "FTA", "FTPerc", "TRB", "ORB", "AST", "STL", "TOV")

df2_1 <- df2[, c(1:5, which(colnames(df2) \%in\% stats), 46:49)]

descr_stats <- c("Games played", "Minutes played", "Points", 
                "Field goals attempted", "Field goals percentage", 
                "3-point field goals attempted", "3-point percentage", 
                "FTA: Free throws attempted", "Free throws percentage", 
                "Total rebounds", "Offensive rebounds", 
                "Assists", "Steals", "Turnovers")

get_bubble_plot(df2_1, "Abalde, Alberto", descr_stats, 6, 10, 12)
}

}
\seealso{
\code{\link[Anthropometry]{percentilsArchetypoid}}
}
\author{
This function has been created using the code from this website:
\url{https://www.r-bloggers.com/2017/01/visualizing-the-best/}.
}
