% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoringprob.R
\name{scoringprob}
\alias{scoringprob}
\title{Plots scoring probability of shots as a function of a given variable}
\usage{
scoringprob(
  data,
  var,
  shot.type,
  players = NULL,
  bw = 20,
  period.length = 12,
  xlab = NULL,
  x.range = "auto",
  title = NULL,
  palette = gg_color_hue,
  team = TRUE,
  col.team = "dodgerblue",
  legend = TRUE
)
}
\arguments{
\item{data}{a data frame whose rows are shots and with the following columns: \code{result}, \code{ShotType}, \code{player} (only if the \code{players} argument is not \code{NULL}) and at least one of \code{playlength}, \code{periodTime}, \code{totalTime}, \code{shot_distance} (the column specified in \code{var}, see Details).}

\item{var}{character, the string giving the name of the numerical variable according to which the scoring probability is estimated. Available options: \code{"playlength"}, \code{"periodTime"}, \code{"totalTime"}, \code{"shot_distance"}.}

\item{shot.type}{character, the type of shots to be analyzed; available options: \code{"2P"}, \code{"3P"}, \code{"FT"}, \code{"field"}.}

\item{players}{subset of players to be displayed (optional; it can be used only if the \code{player} column is present in \code{data}).}

\item{bw}{numeric, the smoothing bandwidth of the kernel density estimator (see \link[stats]{ksmooth}).}

\item{period.length}{numeric, the length of a quarter in minutes (default: 12 minutes as in NBA).}

\item{xlab}{character, x-axis label.}

\item{x.range}{numerical vector or character; available options: \code{NULL} (x-axis range defined by \code{ggplot2}, the default), \code{"auto"} (internally defined x-axis range), or a 2-component numerical vector (user-defined x-axis range).}

\item{title}{character, plot title.}

\item{palette}{color palette.}

\item{team}{character; if \code{TRUE} draws the scoring probability for all the shots in data.}

\item{col.team}{character, color of the scoring probability line for all the shots in data.}

\item{legend}{character; if \code{TRUE}, color legend is displayed (only when \code{players} is not \code{NULL}).}
}
\value{
A \code{ggplot2} plot
}
\description{
Plots scoring probability of shots as a function of a given variable
}
\details{
The \code{data} data frame could also be a play-by-play dataset provided that rows corresponding to events different from shots have \code{NA} in the \code{ShotType} variable.

Required columns:

\itemize{
\item \code{result}, a factor with the following levels: \code{"made"} for made shots, \code{"miss"} for missed shots, and \code{""} for events different from shots
}

\itemize{
\item \code{ShotType}, a factor with the following levels: \code{"2P"}, \code{"3P"}, \code{"FT"} (and \code{NA} for events different from shots)
}

\itemize{
\item \code{player}, a factor with the name of the player who made the shot
}

\itemize{
\item \code{playlength}, a numeric variable with time between the shot and the immediately preceding event
}

\itemize{
\item \code{periodTime}, a numeric variable with seconds played in the quarter when the shot is attempted
}

\itemize{
\item \code{totalTime}, a numeric variable with seconds played in the whole match when the shot is attempted
}

\itemize{
\item \code{shot_distance}, a numeric variable with the distance of the shooting player from the basket (in feet)
}
}
\examples{
PbP <- PbPmanipulation(PbP.BDB)
PbP.GSW <- subset(PbP, team=="GSW" & result!="")
players <- c("Kevin Durant","Draymond Green","Klay Thompson")
scoringprob(data=PbP.GSW, shot.type="2P", players=players,
            var="shot_distance", col.team="gray")
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
