% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACMTF_modelSelection.R
\name{ACMTF_modelSelection}
\alias{ACMTF_modelSelection}
\title{Model selection for ACMTF}
\usage{
ACMTF_modelSelection(
  datasets,
  modes,
  maxNumComponents = 3,
  sharedMode = 1,
  alpha = 1,
  beta = rep(0.001, length(datasets)),
  epsilon = 1e-08,
  nstart = 10,
  cvFolds = 10,
  numCores = 1,
  method = "CG",
  cg_update = "HS",
  line_search = "MT",
  max_iter = 10000,
  max_fn = 1e+05,
  rel_tol = 1e-08,
  abs_tol = 1e-08,
  grad_tol = 1e-08,
  plots = TRUE
)
}
\arguments{
\item{datasets}{List of arrays of datasets. Multi-way and two-way may be combined.}

\item{modes}{Numbered modes per dataset in a list. Example element 1: 1 2 3 and element 2: 1 4 for the X tensor and Y matrix case with a shared subject mode.}

\item{maxNumComponents}{Maximum number of components to check (default 3).}

\item{sharedMode}{Mode that is shared between all blocks, used to remove fibers for numFolds randomly initialized models.}

\item{alpha}{Scalar penalizing the components to be norm 1 (default 1).}

\item{beta}{Vector of penalty values for each dataset, penalizing the lambda terms (default 1e-3).}

\item{epsilon}{Scalar value to make it possible to compute the partial derivatives of lambda (default 1e-8).}

\item{nstart}{Number of randomly initialized models to create (default 10).}

\item{cvFolds}{Number of CV folds to create (default 10).}

\item{numCores}{Number of cores to use (default 1). A number higher than 1 will run the process in parallel.}

\item{method}{Optimization method to use (default = "CG", the conjugate gradient). See \code{\link[mize:mize]{mize::mize()}} for other options.}

\item{cg_update}{Update method for the conjugate gradient algorithm, see \code{\link[mize:mize]{mize::mize()}} for the options (default="HS", Hestenes-Steifel).}

\item{line_search}{Line search algorithm to use, see \code{\link[mize:mize]{mize::mize()}} for the options (default="MT", More-Thuente).}

\item{max_iter}{Maximum number of iterations.}

\item{max_fn}{Maximum number of function evaluations.}

\item{rel_tol}{Relative function tolerance criterion for convergence.}

\item{abs_tol}{Function tolerance criterion for convergence.}

\item{grad_tol}{Absolute tolerence for the l2-norm of the gradient vector.}

\item{plots}{Boolean to state if plots should be made of the outcome.}
}
\value{
List object containing variation explained, FMS, and degeneracy score metrics. If plots=TRUE, plots will be attached to the list.
}
\description{
Model selection for ACMTF
}
\examples{
set.seed(123)

I = 10
J = 5
K = 3
df = array(rnorm(I*J*K), c(I,J,K))
df2 = array(rnorm(I*J*K), c(I,J,K))
datasets = list(df, df2)
modes = list(c(1,2,3), c(1,4,5))

# A very small procedure is run to limit computational requirements
# Plots are not made to reduce CRAN runtime.
result = ACMTF_modelSelection(datasets,
                              modes,
                              maxNumComponents=1,
                              nstart=2,
                              cvFolds=2,
                              rel_tol=1e-1,
                              abs_tol=1e-1,
                              max_iter=2,
                              plots=FALSE)
}
