% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTriangles4Categories.R
\name{PlotTriangles4Categories}
\alias{PlotTriangles4Categories}
\title{Function to convert any 3-d numerical array to a grid of coloured triangles.}
\usage{
PlotTriangles4Categories(
  data,
  brks = NULL,
  cols = NULL,
  toptitle = NULL,
  sig_data = NULL,
  pch_sig = 18,
  col_sig = "black",
  cex_sig = 1,
  xlab = TRUE,
  ylab = TRUE,
  xlabels = NULL,
  xtitle = NULL,
  ylabels = NULL,
  ytitle = NULL,
  legend = TRUE,
  lab_legend = NULL,
  cex_leg = 1,
  col_leg = "black",
  cex_axis = 1.5,
  mar = c(5, 4, 0, 0),
  fileout = NULL,
  size_units = "px",
  res = 100,
  figure.width = 1,
  ...
)
}
\arguments{
\item{data}{Array with three named dimensions: 'dimx', 'dimy', 'dimcat', 
containing the values to be displayed in a coloured image with triangles.}

\item{brks}{A vector of the color bar intervals. The length must be one more 
than the parameter 'cols'. Use ColorBar() to generate default values.}

\item{cols}{A vector of valid colour identifiers for color bar. The length
must be one less than the parameter 'brks'. Use ColorBar() to generate 
default values.}

\item{toptitle}{A string of the title of the grid. Set NULL as default.}

\item{sig_data}{Logical array with the same dimensions as 'data' to add layers 
to the plot. A value of TRUE at a grid cell will draw a dot/symbol on the 
corresponding triangle of the plot. Set NULL as default.}

\item{pch_sig}{Symbol to be used to represent sig_data. Takes 18 
(diamond) by default. See 'pch' in par() for additional accepted options.}

\item{col_sig}{Colour of the symbol to represent sig_data.}

\item{cex_sig}{Parameter to increase/reduce the size of the symbols used 
to represent sig_data.}

\item{xlab}{A logical value (TRUE) indicating if xlabels should be plotted}

\item{ylab}{A logical value (TRUE) indicating if ylabels should be plotted}

\item{xlabels}{A vector of labels of the x-axis The length must be 
length of the col of parameter 'data'. Set the sequence from 1 to the 
length of the row of parameter 'data' as default.}

\item{xtitle}{A string of title of the x-axis. Set NULL as default.}

\item{ylabels}{A vector of labels of the y-axis The length must be 
length of the row of parameter 'data'. Set the sequence from 1 to the 
length of the row of parameter 'data' as default.}

\item{ytitle}{A string of title of the y-axis. Set NULL as default.}

\item{legend}{A logical value to decide to draw the color bar legend or not. 
Set TRUE as default.}

\item{lab_legend}{A vector of labels indicating what is represented in each 
category (i.e. triangle). Set the sequence from 1 to the length of 
the categories (2 or 4).}

\item{cex_leg}{A number to indicate the increase/reductuion of the lab_legend
used to represent sig_data.}

\item{col_leg}{Color of the legend (triangles).}

\item{cex_axis}{A number to indicate the increase/reduction of the axis labels.}

\item{mar}{A numerical vector of the form c(bottom, left, top, right) which 
gives the number of lines of margin to be specified on the four sides of the 
plot.}

\item{fileout}{A string of full directory path and file name indicating where 
to save the plot. If not specified (default), a graphics device will pop up.}

\item{size_units}{A string indicating the units of the size of the device 
(file or window) to plot in. Set 'px' as default. See ?Devices and the 
creator function of the corresponding device.}

\item{res}{A positive number indicating resolution of the device (file or 
window) to plot in. See ?Devices and the creator function of the 
corresponding device.}

\item{figure.width}{a numeric value to control the width of the plot.}

\item{...}{The additional parameters to be passed to function ColorBar() in 
s2dv for color legend creation.}
}
\value{
A figure in popup window by default, or saved to the specified path.
}
\description{
This function converts a 3-d numerical data array into a coloured 
grid with triangles. It is useful for a slide or article to present tabular 
results as colors instead of numbers. This can be used to compare the outputs 
of two or four categories (e.g. modes  of variability, clusters, or forecast 
systems).
}
\examples{
# Example with random data
arr1 <- array(runif(n = 4 * 5 * 4, min = -1, max = 1), dim = c(4,5,4))
names(dim(arr1)) <- c('dimx', 'dimy', 'dimcat')
arr2 <- array(TRUE, dim = dim(arr1))
arr2[which(arr1 < 0.3)] <- FALSE
PlotTriangles4Categories(data = arr1,
                        cols = c('white','#fef0d9','#fdd49e','#fdbb84','#fc8d59'),
                        brks = c(-1, 0, 0.1, 0.2, 0.3, 0.4), 
                        lab_legend = c('NAO+', 'BL','AR','NAO-'), 
                        xtitle = "Target month", ytitle = "Lead time",
                        xlabels = c("Jan", "Feb", "Mar", "Apr"))
}
\author{
History:\cr
1.0  -  2020-10  (V.Torralba, \email{veronica.torralba@bsc.es})  -  Original code
}
