% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDist.R
\name{fitDist}
\alias{fitDist}
\title{Distribution fitting}
\usage{
fitDist(
  data,
  dist,
  n.points,
  norm,
  constrain,
  opts = list(algorithm = "NLOPT_LN_NELDERMEAD", xtol_rel = 1e-08, maxeval = 10000)
)
}
\arguments{
\item{data}{value to be fitted}

\item{dist}{name of the distribution to be fitted}

\item{n.points}{number of points to be subsetted from ecdf}

\item{norm}{norm used for distribution fitting - id ('N1', 'N2', 'N3', 'N4')}

\item{constrain}{logical - constrain shape2 parametes for finite tails}

\item{opts}{minimization options}
}
\description{
Uses Nelder-Mead simplex algorithm to minimize fitting norms.
}
\examples{

x <- fitDist(rnorm(1000), 'norm', 30, 'N1', FALSE)
x

}
