% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_css.R
\name{compute_css}
\alias{compute_css}
\title{Compute Cortisol Sine Score (CSS)}
\usage{
compute_css(data, verbose = FALSE)
}
\arguments{
\item{data}{A data.frame or tibble with subject ID in the first column and cortisol values in time_* columns.
The time columns must be named using 24-hour format, e.g. time_0200, time_1400, etc.}

\item{verbose}{Logical; if TRUE, returns the contribution of each timepoint to the CSS.}
}
\value{
A tibble with subject ID and cortisol_sin_score. If \code{verbose = TRUE}, includes individual contributions.
}
\description{
Calculates the Cortisol Sine Score using timepoint-specific sine weights
extracted from column names like "time_0200", "time_1400", etc.
}
\examples{
# Minimal, always-runnable example using base data.frame
df <- data.frame(
  subject_ID = c("S1", "S2"),
  time_0200 = c(2, 1),
  time_0600 = c(5, 2),
  time_1000 = c(4, 3),
  time_1400 = c(3, 2),
  time_1800 = c(1, 1),
  time_2200 = c(0.5, 0.3),
  stringsAsFactors = FALSE
)
compute_css(df)

}
