% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{comparative_shortest_path}
\alias{comparative_shortest_path}
\title{helper function for csp_cost_segemntation}
\usage{
comparative_shortest_path(
  vox = vox,
  adjacency_df = adjacency_df,
  seeds,
  v_w = 0,
  l_w = 0,
  s_w = 0,
  N_cores = parallel::detectCores() - 1,
  Voxel_size
)
}
\arguments{
\item{vox}{a LAS S4 element with XYZ voxel coordinates in the @data slot.}

\item{adjacency_df}{a data.frame with voxel ids (row numbers) in the first
column and a neighboring voxel ID in the second column and the weight
(distance) in the third column. Might be generated using the dbscan::frNN
function (which requires reshaping the data).}

\item{seeds}{seed points for tree positions.}

\item{v_w, l_w, s_w}{weights for verticality, linearity spericity see
\code{\link{csp_cost_segmentation}}}

\item{N_cores}{Number of CPU cores for multi-threading}

\item{Voxel_size}{Edge length used to create the voxels. This is only
important to gain comparable distance weights on different voxel sizes.
Should be greater than 0.}
}
\value{
voxels with the TreeID in the data slot
}
\description{
The function performs a Dijkstra algorithm on a 3D voxel file to assign
every voxel to the closest seed point using the igraph package.
}
\seealso{
\code{\link{csp_cost_segmentation}}
}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
