% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite.R
\name{readSQLite}
\alias{readSQLite}
\title{Load data frame from SQLite.
This function reads a data frame from an SQLite database file created with \code{saveSQLite}.}
\usage{
readSQLite(
  task,
  type,
  subdir = NULL,
  dirCreate = FALSE,
  tableName = "data",
  n = NULL,
  offset = 0
)
}
\arguments{
\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Filename type. If the type is an array, the cocatenation of the elements is used with separator"-". Filenames have the form [task name]_[type].[ext]}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{tableName}{name of the table in the SQLite database.}

\item{n}{number of rows to read (if NULL, all rows are read).}

\item{offset}{number of rows to skip before reading (default is 0).}
}
\value{
Data frame with requested table.
}
\description{
Load data frame from SQLite.
This function reads a data frame from an SQLite database file created with \code{saveSQLite}.
}
