% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb_functions.R
\name{plot_string_network}
\alias{plot_string_network}
\title{Plot STRING Network}
\usage{
plot_string_network(
  string_db,
  string_ids,
  file_directory = NULL,
  export = FALSE
)
}
\arguments{
\item{string_db}{A STRINGdb object.}

\item{string_ids}{A list of STRING IDs.}

\item{file_directory}{Directory for saving the output plot. Defaults to NULL.}

\item{export}{Logical indicating whether to export the plot. Defaults to FALSE.}
}
\value{
Invisibly returns NULL.
}
\description{
Plot STRING network interactions using STRINGdb.
}
\examples{
library(STRINGdb)
string_db <- STRINGdb$new(species = 9606)
string_ids <- c("9606.ENSP00000269305", "9606.ENSP00000357940")
plot_string_network(string_db, string_ids, file_directory = tempdir(), export = FALSE)
}
