/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.pograss;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.pograss.PoGraSSimage;

public class PoGraSSgraphics
extends PoGraSS {
    public Graphics2D g;
    Color[] c;
    String[] cn;
    int cs;
    int fillSt;
    int cx;
    int cy;
    int curLayer = 0;
    int paintLayer = 0;
    Color curFillC;
    Color curPenC;
    Font currentFont;

    public PoGraSSgraphics(Graphics2D graphics2D, int n) {
        this.g = graphics2D;
        this.c = new Color[128];
        this.cn = new String[128];
        this.cs = 0;
        this.fillSt = 0;
        this.lineWidth = 1.0f;
        this.curFillC = Color.white;
        this.curPenC = Color.black;
        this.localLayerCache = this.paintLayer = n;
        this.setFontStyle(this.lastFontAttr);
        graphics2D.setColor(this.curPenC);
    }

    public PoGraSSgraphics(Graphics2D graphics2D) {
        this(graphics2D, -1);
    }

    Color getColor(String string) {
        for (int i = 0; i < this.cs; ++i) {
            if (this.cn[i].compareTo(string) != 0) continue;
            return this.c[i];
        }
        return Color.black;
    }

    public void defineColor(String string, int n, int n2, int n3) {
        if (this.cs < 128) {
            this.cn[this.cs] = new String(string);
            this.c[this.cs] = new Color(n, n2, n3);
            ++this.cs;
        }
    }

    public void defineColor(String string, float f, float f2, float f3, float f4) {
        if (this.cs < 128) {
            this.cn[this.cs] = new String(string);
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            this.c[this.cs] = f4 > 0.99f ? new Color(f, f2, f3) : new Color(f, f2, f3, f4);
            ++this.cs;
        }
    }

    public void setColor(String string, float f) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            if (f > 0.99f) {
                this.setColor(string);
                return;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            float[] fArray = this.getColor(string).getRGBComponents(null);
            this.curPenC = new Color(fArray[0], fArray[1], fArray[2], f);
            this.g.setColor(this.curPenC);
        }
    }

    public void setColor(float f, float f2, float f3, float f4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.curPenC = new Color(f, f2, f3, f4);
            this.g.setColor(this.curPenC);
        }
    }

    public void setColor(int n, int n2, int n3) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.curPenC = new Color(n, n2, n3);
            this.g.setColor(this.curPenC);
        }
    }

    public void setColor(String string) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.curPenC = this.getColor(string);
            this.g.setColor(this.curPenC);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawLine(n, n2, n3, n4);
        }
    }

    public void moveTo(int n, int n2) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.cx = n;
            this.cy = n2;
        }
    }

    public void lineTo(int n, int n2) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawLine(this.cx, this.cy, n, n2);
            this.cx = n;
            this.cy = n2;
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawRect(n, n2, n3, n4);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.fillRect(n, n2, n3, n4);
        }
    }

    public void drawImage(PoGraSSimage poGraSSimage, int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawImage(poGraSSimage.getImage(), n, n2, n3 - n, n4 - n2, null);
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawOval(n, n2, n3, n4);
        }
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.fillOval(n, n2, n3, n4);
        }
    }

    public void drawString(String string, int n, int n2) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.drawString(string, n, n2);
        }
    }

    public void drawString(String string, int n, int n2, int n3) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            if ((n3 & 3) == 1 || (n3 & 3) == 2) {
                FontMetrics fontMetrics = this.g.getFontMetrics();
                int n4 = fontMetrics.stringWidth(string);
                if ((n3 & 3) == 2) {
                    n4 /= 2;
                }
                this.g.drawString(string, n - n4, n2);
            } else {
                this.g.drawString(string, n, n2);
            }
        }
    }

    public void drawString(String string, int n, int n2, double d, double d2) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getHeight();
            n3 = (int)((double)n3 * d);
            n4 = (int)((double)n4 * d2);
            this.g.drawString(string, n - n3, n2 + n4);
        }
    }

    public void drawString(String string, int n, int n2, double d, double d2, double d3) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getHeight();
            n3 = (int)((double)n3 * d);
            n4 = (int)((double)n4 * d2);
            Graphics2D graphics2D = this.g;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n, n2);
            graphics2D.rotate(-d3 * Math.PI / 180.0);
            graphics2D.drawString(string, -n3, n4);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            if (bl) {
                this.g.drawPolygon(nArray, nArray2, n);
            } else {
                this.g.drawPolyline(nArray, nArray2, n);
            }
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.paintLayer == -1 || this.paintLayer == this.curLayer) {
            this.g.fillPolygon(nArray, nArray2, n);
        }
    }

    public void setFontFace(int n) {
        this.lastFace = "SansSerif";
        if (n == 2) {
            this.lastFace = "Serif";
        }
        if (n == 3) {
            this.lastFace = "Monospaced";
        }
        this.lastFont = n;
        this.currentFont = new Font(this.lastFace, this.lastFontAttr, (int)(0.5 + this.lastFontSize));
        this.g.setFont(this.currentFont);
    }

    public void setOptionalFace(String string) {
        this.lastFace = string;
        this.currentFont = new Font(this.lastFace, this.lastFontAttr, (int)(0.5 + this.lastFontSize));
        this.g.setFont(this.currentFont);
    }

    public void setFontSize(double d) {
        this.lastFontSize = d;
        this.currentFont = new Font(this.lastFace, this.lastFontAttr, (int)(0.5 + this.lastFontSize));
        this.g.setFont(this.currentFont);
    }

    public void setFontStyle(int n) {
        this.lastFontAttr = 0;
        if ((n & 1) > 0) {
            this.lastFontAttr |= 2;
        }
        if ((n & 2) > 0) {
            this.lastFontAttr |= 1;
        }
        this.currentFont = new Font(this.lastFace, this.lastFontAttr, (int)(0.5 + this.lastFontSize));
        this.g.setFont(this.currentFont);
    }

    public void nextLayer() {
        ++this.curLayer;
    }

    public void begin() {
        this.curLayer = 0;
    }

    public void end() {
    }

    public int getWidthEstimate(String string) {
        Rectangle rectangle = this.g.getFontMetrics().getStringBounds(string, this.g).getBounds();
        return rectangle.width;
    }

    public int getHeightEstimate(String string) {
        Rectangle rectangle = this.g.getFontMetrics().getStringBounds(string, this.g).getBounds();
        return rectangle.height;
    }

    public void setGlobalAlpha(float f) {
        this.g.setComposite(AlphaComposite.getInstance(3, f));
    }

    public void resetGlobalAlpha() {
        this.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void setLineWidth(float f) {
        super.setLineWidth(f);
        this.g.setStroke(new BasicStroke(f));
    }

    public void resetClip() {
        this.g.setClip(this.getBounds());
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
    }
}

