% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-Epoch-plot.r
\name{plot,Epoch,missing-method}
\alias{plot,Epoch,missing-method}
\title{Plot method for Epoch objects}
\usage{
\S4method{plot}{Epoch,missing}(
  x,
  y,
  gap = 2,
  groupIndex = NULL,
  timeResolution = 2048,
  maxLabels = 50,
  linewidth = 0.2,
  x.lab.size = 10,
  y.lab.size = 10,
  standardize = TRUE,
  ...
)
}
\arguments{
\item{x}{An Epoch object}

\item{y}{Not used (for S4 method compatibility)}

\item{gap}{Numeric value specifying the gap between electrode traces (default: 2)}

\item{groupIndex}{Integer or string. A group of electrodes to show together in a different color. If NULL(default), all electrodes are shown in the same color.}

\item{timeResolution}{Maximum number of time points to keep for each electrode (default: 2048)}

\item{maxLabels}{Maximum number of electrode labels to display on the y-axis (default: 50)}

\item{linewidth}{Line width for the electrode traces (default: 0.2)}

\item{x.lab.size}{Size of the x-axis label text (default: 10)}

\item{y.lab.size}{Size of the y-axis label text (default: 10)}

\item{standardize}{If the parameter is a logical value, it indicates whether to standardize the iEEG data across time for each electrode. If it is a logical vector with length equal to the number of electrodes, it indicates whether to standardize each electrode individually. If it is a numeric vector with length equal to the number of electrodes, it indicates the standard deviation to use for standardization for each electrode. (default: TRUE).}

\item{...}{Additional arguments (not currently used)}
}
\value{
\code{plot}: A ggplot object showing iEEG electrode traces
}
\description{
Plot method for Epoch objects
}
\examples{
# Create an Epoch object
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

# Plot the epoch
plot(epoch)


}
\seealso{
Other Epoch methods: 
\code{\link{coltimes}()},
\code{\link{crop}()},
\code{\link{resample}()},
\code{\link{show,Epoch-method}}
}
\concept{Epoch methods}
