% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_utils.R
\name{.ts_pmm2_fit}
\alias{.ts_pmm2_fit}
\title{PMM2 fitting algorithm for time series models}
\usage{
.ts_pmm2_fit(
  b_init,
  innovations_init,
  model_info,
  m2,
  m3,
  m4,
  max_iter = 50,
  tol = 1e-06,
  regularize = TRUE,
  reg_lambda = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{b_init}{initial parameter estimates (AR followed by MA)}

\item{innovations_init}{initial innovations (errors)}

\item{model_info}{list with model structure information}

\item{m2, m3, m4}{central moments}

\item{max_iter}{maximum number of iterations}

\item{tol}{convergence tolerance}

\item{regularize}{logical, add small value to diagonal for numerical stability}

\item{reg_lambda}{regularization parameter (if regularize=TRUE)}

\item{verbose}{logical, whether to print progress information}
}
\value{
A list with components:
\item{b}{estimated parameters}
\item{convergence}{logical convergence status}
\item{iterations}{number of iterations performed}
\item{innovations}{final innovations (errors)}
}
\description{
Implementation of PMM2 algorithm for time series models with various approaches
depending on the model structure (AR, MA, ARMA, ARIMA)
}
\keyword{internal}
