% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRglm.R
\name{RRglm}
\alias{RRglm}
\title{Fitting Generalized Linear Models with binary Randomized Response data}
\usage{
RRglm(formula, link, item, RRmodel, p1, p2, data, na.action = "na.omit", ...)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the model to be fitted,
with the response on the left of a ~ operator and the terms, separated by + operators, on the right.}

\item{link}{a glm link function for binary outcomes. Must be a function name.
Available options: "RRlink.logit", "RRlink.probit", "RRlink.cloglog" and "RRlink.cauchit"}

\item{item}{optional item identifier for long-format data.}

\item{RRmodel}{the Randomized Response model, defined per case.
Available options: "DQ", "Warner", "Forced", "UQM", "Crosswise", "Triangular" and "Kuk"}

\item{p1}{the Randomized Response parameter p1, defined per case. Must be 0 <= p1 <= 1.}

\item{p2}{the Randomized Response parameter p2, defined per case. Must be 0 <= p2 <= 1.}

\item{data}{a data frame containing the variables named in \code{\link{formula}} as well as the Randomized Response model and parameters.
If the required information cannot be found in the data frame, or if no data frame is given, then the variables are taken
from the environment from which RRglm is called.}

\item{na.action}{a function that indicates what should happen when the data contain NAs.
The default action (\code{\link[stats:na.omit]{na.omit}}, as given by \code{getOption("na.action"))})
strips any observations with any missing values in any variables.}

\item{...}{other potential arguments to be passed to \code{\link[stats]{glm}}.}
}
\value{
An object of class RRglm. Extends the class \code{glm} with Randomize Response data.
}
\description{
Fit a generalized linear model (GLM) with binary Randomized Response data.
Implemented as a wrapper for \code{\link[stats:glm]{glm}}. Reference: Fox, J-P, Veen, D. and Klotzke, K. (2018).
Generalized Linear Mixed Models for Randomized Responses. \emph{Methodology.} https://doi.org/10.1027/1614-2241/a000153
}
\examples{
# Fit the model with fixed effects for gender, RR, pp and age using the logit link function.
# The Randomized Response parameters p1, p2 and model
# are specified for each observation in the dataset.
out <- RRglm(response ~ Gender + RR + pp + age, link="RRlink.logit", RRmodel=RRmodel,
         p1=RRp1, p2=RRp2, data=Plagiarism, etastart=rep(0.01, nrow(Plagiarism)))
summary(out)
}
\seealso{
\code{\link[stats:glm]{glm}}
}
