% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour_image_grid.R
\name{contour_image_grid}
\alias{contour_image_grid}
\title{Draws the density / distribution function of a grid copula with contours and colors}
\usage{
contour_image_grid(
  gc,
  FUN = "p.grid",
  u1 = seq(0, 1, length.out = 100),
  u2 = seq(0, 1, length.out = 100),
  color.name = "heat.colors",
  color.size = 40
)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{FUN}{the name of the function to be applied (d.grid, p.grid), default is 'p.grid'.}

\item{u1}{indicates the place for lines on axis \eqn{u_1}.}

\item{u2}{indicates the place for lines on axis \eqn{u_2}.}

\item{color.name}{indicates the palette of colors.}

\item{color.size}{indicates the number of colors.}
}
\value{
Returns a graph of the density / distribution.
}
\description{
Draws the density / distribution function of a grid copula with contours and colors
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ls")
contour_image_grid(gc = copula.grid, FUN = 'd.grid', color.name= "rainbow", color.size = 10)
contour_image_grid(gc = copula.grid, FUN = 'p.grid', color.name = "rainbow", color.size = 10)

#Iris
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = k, m = m , method = "ls")
contour_image_grid(gc = copula.grid, FUN = 'd.grid', color.name= "rainbow", color.size = 10)
contour_image_grid(gc = copula.grid, FUN = 'p.grid', color.name = "rainbow", color.size = 10)
}
