#' Hellinger Distance Between Distributions
#'
#' Calculates the Hellinger distance between two probability distributions.
#'
#' @param p A probability vector.
#' @param q Another probability vector of same length as p.
#' @return Hellinger distance between p and q.
#' @export
hellinger.dist <- function(p, q) {
  sum = 0
  for (i in 1:length(p)) {
    sum = sum + (sqrt(p[i]) - sqrt(q[i]))^2
  }
  result = (1 / sqrt(2)) * sqrt(sum)
  return(result)
}
