#' Proportion of Non-Intersecting Arc Pairs in an RCAG.
#'
#' Computes the proportion of non-intersecting pairs of arcs in the RCAG obtained using data.
#'
#' @param s Start points of arcs.
#' @param t End points of arcs.
#' @param e1 Vector of indices for the first interval in each pair.
#' @param e2 Vector of indices for the second interval in each pair.
#' @return Mean proportion of non-intersecting pairs.
#' @examples
#' s <- circular::rcircularuniform(10) 
#' t <- circular::rcircularuniform(10)
#' e1 <- c(2,10,6,1,5)
#' e2 <- c(4,3,8,7,9)
#' nip.rcag(s,t,e1,e2)
#' @export
nip.rcag <- function(s, t, e1, e2) {
  n <- length(e1)
  not_intersect = numeric(n)
  for (i in 1:n) {
    if (s[e1[i]] < t[e1[i]] && t[e1[i]] < s[e2[i]] && s[e2[i]] < t[e2[i]])
      not_intersect[i] = 1
    else if (t[e2[i]] < s[e1[i]] && s[e1[i]] < t[e1[i]] && t[e1[i]] < s[e2[i]])
      not_intersect[i] = 1
    else if (s[e2[i]] < t[e2[i]] && t[e2[i]] < s[e1[i]] && s[e1[i]] < t[e1[i]])
      not_intersect[i] = 1
    else if (t[e1[i]] < s[e2[i]] && s[e2[i]] < t[e2[i]] && t[e2[i]] < s[e1[i]])
      not_intersect[i] = 1
    else 
      not_intersect[i] = 0
  }
  return(mean(not_intersect)) 
}
