#' Proportion of Non-Intersecting Interval Pairs in an RIG
#'
#' Computes the proportion of non-intersecting pairs of interval in the RIG obtained using data.
#'
#' @param s Start points of intervals.
#' @param t End points of intervals.
#' @param e1 Vector of indices for the first interval in each pair.
#' @param e2 Vector of indices for the second interval in each pair.
#' @return Mean proportion of non-intersecting pairs.
#' @examples
#' s <- runif(10,0,1) 
#' t <- runif(10,0,1)
#' e1 <- c(2,10,6,1,5)
#' e2 <- c(4,3,8,7,9)
#' nip.rig(s,t,e1,e2)
#' @export
nip.rig <- function(s, t, e1, e2) {
  not_intersect <- c()
  for (i in 1:length(e1)) {
    if (s[e1[i]] <t[e1[i]] && t[e1[i]] < s[e2[i]] && s[e2[i]] < t[e2[i]] )
      not_intersect[i] = 1
    else if (t[e1[i]] <s[e1[i]] && s[e1[i]] < s[e2[i]] && s[e2[i]] < t[e2[i]])
      not_intersect[i] = 1
    else if (s[e1[i]] <t[e1[i]] && t[e1[i]] < t[e2[i]] && t[e2[i]] < s[e2[i]])
      not_intersect[i] = 1
    else if (t[e1[i]] <s[e1[i]] && s[e1[i]] < t[e2[i]] && t[e2[i]] < s[e2[i]])
      not_intersect[i] = 1
    else if (s[e2[i]] <t[e2[i]] && t[e2[i]] < s[e1[i]] && s[e1[i]] < t[e1[i]])
      not_intersect[i] = 1 
    else if (s[e2[i]] <t[e2[i]] && t[e2[i]] < s[e1[i]] && s[e1[i]] < t[e1[i]])
      not_intersect[i] = 1 
    else if (s[e2[i]] <t[e2[i]] && t[e2[i]] < t[e1[i]] && t[e1[i]] < s[e1[i]])
      not_intersect[i] = 1 
    else if (t[e2[i]] <s[e2[i]] && s[e2[i]] < s[e1[i]] && s[e1[i]] < t[e1[i]])
      not_intersect[i] = 1 
    else if (t[e2[i]] <s[e2[i]] && s[e2[i]] < t[e1[i]] && t[e1[i]] < s[e1[i]])
      not_intersect[i] = 1 
    else 
      not_intersect[i] = 0 
  }
  return(mean(not_intersect))
}
