% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcagdd.test.R
\name{rcagdd.test}
\alias{rcagdd.test}
\title{RCAG-DD Test}
\usage{
rcagdd.test(theta)
}
\arguments{
\item{theta}{A numeric vector representing endpoints of arcs.}
}
\value{
Vector of test statistics of RCAG-DD Test.
}
\description{
Performs the RCAG-DD RIG-DD test of randomness for circular data.
}
\examples{
x <- arima.sim(model = list(ar=c(0.6,0.3)), 1000) ## AR(2) model
theta <- ((2*atan(x))\%\%(2*pi))*(180/pi) ##LAR(2) model
rcagdd.test(theta)
}
