#'@title Simulation of multidimensional Brownian motion
#'@description This function is used to simulate multidimensional Brownian motion at points  0,1/n, ..., 1.
#'
#'@param n   Number of simulated
#'@param d   Dimension of BM
#'
#'@return \item{W}{Brownian motion }
#'
#'@examples
#' W =  SimBM(100,4)
#'
#'@export
#'



SimBM = function(n,d)
{
  dt <- 1 / n
  W=matrix(0,ncol=d,nrow=(n+1))
  for(j in 1:d)
    {
    W[,j] <- c(0, cumsum(rnorm(n)))/sqrt(n)

  }

  return(W)

}
