% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyplot.R
\name{easyplot}
\alias{easyplot}
\title{Easy way to plot networks similar to `Gephi'}
\usage{
easyplot(
  graph,
  layout,
  label_size = 3,
  edge_color = NULL,
  vertex_size = rep(3, vcount(graph)),
  edge_arrow_size = 0.2,
  vertex_label_color = "black"
)
}
\arguments{
\item{graph}{An \code{igraph} object. The graph must contain vertex color attributes.}

\item{layout}{A matrix representing the layout of the graph. Typically obtained from layout functions like \code{layout_with_fr} or \code{layout.forceatlas2}.}

\item{label_size}{A numeric value indicating the size of the vertex labels. Default is 3. Note that when exporting a plot, label size will likely need to be adjusted depending on the plot size.}

\item{edge_color}{A character vector of colors for the edges. If not provided, the default color is black.}

\item{vertex_size}{A numeric vector indicating the size of the vertices. Default is 15 for all vertices.}

\item{edge_arrow_size}{A numeric value indicating the size of the arrows at the end of the edges. Default is 0.2.}

\item{vertex_label_color}{A character string specifying the color of the vertex labels. Default is "black".}
}
\value{
A plot of the graph with the specified parameters.
}
\description{
This function provides an easy interface for plotting a graph in a similar style to `Gephi'.
It has a customizable layout, label size, edge color, vertex size, edge arrow size, and vertex label color.
}
\examples{
  library(igraph)

  # Creating a sample graph
  g <- sample_gnp(10, 0.3)
  V(g)$name <- letters[1:10]
  V(g)$color <- rainbow(10)
  layout <- layout_with_fr(g)

  # Plot the graph using easyplot
  easyplot(g, layout, label_size = 1, vertex_size = rep(10, vcount(g)))

  # Assign edge colors based on source node colors
  g <- assign_edge_colors(g, transparency = 0.4)

  # Plot the graph using easyplot, now with edge color
  easyplot(g, layout, label_size = 1, vertex_size = rep(10, vcount(g)))

}
