% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_into_train_validate_test.R
\name{split_into_train_validate_test}
\alias{split_into_train_validate_test}
\title{Split Dataframe into: 'train', 'validate', 'test'}
\usage{
split_into_train_validate_test(
  df,
  train_prop = 0.7,
  validate_prop = 0.15,
  test_prop = 0.15,
  seed = NULL
)
}
\arguments{
\item{df}{A data frame to be split into subsets.}

\item{train_prop}{A numeric value between 0 and 1 specifying the proportion
of data to allocate to the training set.}

\item{validate_prop}{A numeric value between 0 and 1 specifying the proportion
of data to allocate to the validation set.}

\item{test_prop}{A numeric value between 0 and 1 specifying the proportion
of data to allocate to the test set.}

\item{seed}{(optional) a numeric value to set the random no. seed within function environment.}
}
\value{
A named list with three elements:
\describe{
  \item{train}{A data frame containing the training subset}
  \item{validate}{A data frame containing the validation subset}
  \item{test}{A data frame containing the test subset}
}
}
\description{
This function randomly splits a data frame into three subsets for machine
learning workflows: training, validation, and test sets. The proportions
can be customized and must sum to 1.
}
\details{
The function assigns each row to either "train", "validate" or "test" with
the probability defined in the function.

Because each row is assigned a bucket independently, for very small datasets the proportions may not
be as desired. This should not be an issue as data used for `iblm` must be reasonably large.
}
\examples{
# Using 'mtcars'
split_into_train_validate_test(
  mtcars,
  train_prop = 0.6,
  validate_prop = 0.2,
  test_prop = 0.2,
  seed = 9000
)

}
