% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t.R
\name{iscamonesamplet}
\alias{iscamonesamplet}
\title{One Sample T-Test}
\usage{
iscamonesamplet(
  xbar,
  sd,
  n,
  hypothesized = 0,
  alternative = NULL,
  conf.level = NULL,
  verbose = TRUE
)
}
\arguments{
\item{xbar}{Observed mean.}

\item{sd}{Observed standard deviation.}

\item{n}{Sample size.}

\item{hypothesized}{Hypothesized population mean.}

\item{alternative}{"less", "greater", or "two.sided"}

\item{conf.level}{Confidence level.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
The t value, p value, and confidence interval.
}
\description{
\code{onesamplet} calculates a one sample t-test and/or interval from summary statistics.
It defaults to a hypothesized population mean of 0. You can optionally set an
alternative hypothesis and confidence level for a two-sided confidence interval.
}
\examples{
iscamonesamplet(
  xbar = 2.5,
  sd = 1.2,
  n = 30,
  alternative = "greater",
  hypothesized = 2
)
iscamonesamplet(
  xbar = 10.3,
  sd = 2,
  n = 50,
  alternative = "less",
  hypothesized = 11
)
iscamonesamplet(
  xbar = 98.2,
  sd = 2,
  n = 100,
  alternative = "two.sided",
  conf.level = 0.95
)
iscamonesamplet(xbar = 55, sd = 5, n = 40, conf.level = 0.99)
}
