% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_coa.R
\name{assess_coa}
\alias{assess_coa}
\title{Assess course objective achievement}
\usage{
assess_coa(data, session_weights, objective_weights1, ...)
}
\arguments{
\item{data}{A wide-format data.frame that only contains student's grades of each session.
\code{assess_coa} assumes the highest score for each session and the final grade is 100,
given that weights are assigned by users.}

\item{session_weights}{A vector that Weights sessions for the final grade.
The length of \code{session_weights} is the number of sessions. Typically,
the final grade is based on the regular grade and final exam grade,
in which condition the length of \code{session_weights} is 2. The range of each weight should be 0-1.
The sum of \code{session_weights} should be 1.}

\item{objective_weights1}{A vector that Weights course objectives for session 1.
The length of objective_weights1 is the number of course objectives.
The range of each weight should be 0-1. The sum of \code{objective_weights1} should be 1.}

\item{...}{objective_weights2, objective_weights3, ...
Other vectors that Weight course objectives for session1, session2, ...
The number of objective_weights* arguments should be equal to the length of \code{session_weights}.}
}
\value{
A data.frame containing grades of each session, final grades, and achievements of each
objective. This data.frame also has an attribute named "weights" that contains a list of
session_weights, objective_weights_matrix, and weighted_objective_weights_matrix
}
\description{
Assess course objective achievement
}
\examples{
data <- data.frame(
  session1 = 60 + sample.int(40, 100, 1),
  session2 = 60 + sample.int(40, 100, 1),
  session3 = 60 + sample.int(40, 100, 1)
)
session_weights    <- c(0.2, 0.3, 0.5)
objective_weights1 <- c(0.1, 0.4, 0.5)
objective_weights2 <- c(0.2, 0.2, 0.6)
objective_weights2 <- c(0.3,   0, 0.7)
coa <- assess_coa(
  data,
  session_weights,
  objective_weights1,
  objective_weights2,
  objective_weights2
)
head(coa)
attr(coa, "weights")
colMeans(coa[row.names(attr(coa, "weights")[[2]])])
}
