% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_qvb_global.R
\name{lr_qvb_global}
\alias{lr_qvb_global}
\title{Global Low Rank Correction Quantile VB}
\usage{
lr_qvb_global(X, Z, y, tau, eps = 0.001)
}
\arguments{
\item{X}{Homogeneous covariates}

\item{Z}{Heterogeneous covariates}

\item{y}{Response covariates}

\item{tau}{Quantile Levels}

\item{eps}{Algorithm convergence tolerance, Defaut:1e-3}
}
\value{
The mean of the homogeneous coefficient:mu;
Low-rank correction of homogeneous coefficients:lr_mu;
The variance of homogeneous coefficient:sigma;
Selection homogeneous coefficient:rho;
The mean of the heterogeneous coefficient:beta;
Low-rank correction of heterogeneous coefficients:lr_beta;
The variance of heterogeneous coefficient:sigma_beta;
Selection heterogeneous coefficient:rho_beta.
}
\description{
A variational Bayesian algorithm is proposed for multi-source heterogeneous quantile models under the
Spike-and-Slab prior, enabling simultaneous variable selection for both homogeneous and
heterogeneous covariates.
}
