% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA_algorithm.R
\name{PA_algorithm}
\alias{PA_algorithm}
\title{Title Pearson-Aitken algorithm to calculate mean values in truncated multivariate normal distributions}
\usage{
PA_algorithm(mu, covmat, target_id, lower, upper, K_i = NA, K_pop = NA)
}
\arguments{
\item{mu}{vector of means}

\item{covmat}{covariance matrix, contaning kinship coefficient and heritability on each entry (except diagnoal, which is 1 for full liabilities and h2 for genetic liabilities)}

\item{target_id}{ID of target individual (or genetic liability), i.e. rowname in covmat to return expected genetic liability for}

\item{lower}{vector of lower thresholds}

\item{upper}{vector of upper thresholds}

\item{K_i}{vector of stratified CIPs for each individual. Only used for estimating genetic liability under the mixture model.}

\item{K_pop}{vector of population CIPs. Only used for estimating genetic liability under the mixture model.}
}
\value{
A list with two elements: est (expected genetic liability, given input data) and var (variance of genetic liability, given input data).
}
\description{
Title Pearson-Aitken algorithm to calculate mean values in truncated multivariate normal distributions
}
