% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R
\name{smooth_RLum}
\alias{smooth_RLum}
\alias{smooth_RLum,list-method}
\alias{smooth_RLum,RLum.Analysis-method}
\alias{smooth_RLum,RLum.Data.Curve-method}
\title{Smoothing of data for RLum-class objects}
\usage{
smooth_RLum(object, ...)

\S4method{smooth_RLum}{list}(object, ...)

\S4method{smooth_RLum}{RLum.Analysis}(object, ...)

\S4method{smooth_RLum}{RLum.Data.Curve}(
  object,
  k = NULL,
  fill = NA,
  align = "right",
  method = "mean",
  p_acceptance = 1e-07
)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}

\item{k}{\code{\link{smooth_RLum}}; \link{integer} (\emph{with default}):
window for the rolling mean or median. If \code{NULL}, this set automatically
(ignored if \code{method = "Carter_etal_2018"}).}

\item{fill}{\code{\link{smooth_RLum}}; \link{numeric} (\emph{with default}):
value used to pad the result so to have the same length as the input.}

\item{align}{\code{\link{smooth_RLum}}; \link{character} (\emph{with default}):
one of \code{"right"}, \code{"center"} or \code{"left"}, specifying whether the index
of the result should be right-aligned (default), centred, or left-aligned
compared to the rolling window of observations (ignored if
\code{method = "Carter_etal_2018"}).}

\item{method}{\code{\link{smooth_RLum}}; \link{character} (\emph{with default}):
smoothing method to be applied: one of \code{"mean"}, \code{"median"} or
\code{"Carter_etal_2018"}.}

\item{p_acceptance}{\code{\link{smooth_RLum}}; \link{numeric} (\emph{with default}):
probability threshold of accepting a value to be a sample from a Poisson
distribution (only used for \code{method = "Carter_etal_2018"}). Values that
have a Poisson probability below the threshold are replaced by the average
over the four neighbouring values.}
}
\value{
An object of the same type as the input object provided.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected. The smoothing is performed in the internal
function \code{.smoothing()}.
}
\section{Functions}{
\itemize{
\item \code{smooth_RLum(list)}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{smooth_RLum}

\item \code{smooth_RLum(RLum.Analysis)}: Smoothing of \code{RLum.Data} records contained in the input object.

\item \code{smooth_RLum(RLum.Data.Curve)}: Smoothing of \linkS4class{RLum.Data.Curve} objects using a rolling mean or median.
For methods \code{"mean"} and \code{"median"}, smoothing is performed by rolling
mean and rolling median with window of size \code{k}. Method \code{"Carter_etal_2018"}
implements a Poisson smoother for dark-background signals measured by a
photomultiplier tube.

}}
\note{
Currently only \code{RLum} objects of class \code{RLum.Data.Curve} and \code{RLum.Analysis}
(with curve data) are supported.
}
\section{Function version}{
 0.1.0
}

\examples{

## load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

## create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

## plot data without and with smoothing
plot_RLum(curve)
plot_RLum(smooth_RLum(curve))

} 

\section{How to cite}{
Kreutzer, S., 2025. smooth_RLum(): Smoothing of data for RLum-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\references{
Carter, J., Cresswell, A.J., Kinnaird, T.C., Carmichael, L.A., Murphy, S. &
Sanderson, D.C.W., 2018. Non-Poisson variations in photomultipliers and
implications for luminescence dating. Radiation Measurements 120, 267-273.
\doi{10.1016/j.radmeas.2018.05.010}
}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{utilities}
