% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-AlleleSail.R
\name{cubeAlleleSail}
\alias{cubeAlleleSail}
\title{Inheritance Cube: 3-Piece Allele Sail}
\usage{
cubeAlleleSail(
  cMM = 0,
  crMM = 0,
  cPM = 0,
  crPM = 0,
  cMF = 0,
  crMF = 0,
  cPF = 0,
  crPF = 0,
  dMW = 0,
  dMrW = 0,
  dPW = 0,
  dPrW = 0,
  crF12 = 0.5,
  crM12 = 0.5,
  crF23 = 0.5,
  crM23 = 0.5,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cMM}{Cutting efficacy of maternally-inherited Cas9 in males}

\item{crMM}{Resistance rate of maternally-inherited Cas9 in males}

\item{cPM}{Cutting efficacy of paternally-inherited Cas9 in males}

\item{crPM}{Resistance rate of paternally-inherited Cas9 in males}

\item{cMF}{Cutting efficacy of maternally-inherited Cas9 in females}

\item{crMF}{Resistance rate of maternally-inherited Cas9 in females}

\item{cPF}{Cutting efficacy of paternally-inherited Cas9 in females}

\item{crPF}{Resistance rate of paternally-inherited Cas9 in females}

\item{dMW}{Female deposition cutting rate, maternal Cas9}

\item{dMrW}{Female deposition functional resistance rate, maternal Cas9}

\item{dPW}{Female deposition (HH) cutting rate, paternal Cas9}

\item{dPrW}{Female deposition (HH) functional resistance rate, paternal Cas9}

\item{crF12}{Female crossover rate between loci 1 and 2, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{crM12}{Male crossover rate between loci 1 and 2, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{crF23}{Female crossover rate between loci 2 and 3, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{crM23}{Male crossover rate between loci 2 and 3, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
A generalized implementation of the Allele Sail (\doi{10.1038/s41467-024-50992-9})
idea.
}
\details{
This is an autosomal, 3-locus system. The first locus contains the Cas9
allele, the second locus carries the gRNA, and the third locus is the target.
All loci can be linked/unlinked to the locus before it (so, 1 to 2 or 2 to 3).
Cas9 efficacy due to provenance (mother vs father) is included.

This construct is very similar to our \link[=cubeClvR2]{2-locus Cleave and Rescue} design for
Oberhofer et. al.(\doi{10.1101/2020.07.09.196253}).

This construct has 3 alleles at the first locus, 2 alleles at the second locus,
and 3 alleles at the third locus.
\itemize{
\item Locus 1
\itemize{
\item W: Wild-type
\item P: Paternal Cas9
\item M: Maternal Cas9
}
\item Locus 2
\itemize{
\item W: Wild-type
\item G: gRNAs
}
\item Locus 3
\itemize{
\item W: Wild-type
\item R: Resistant 1
\item B: Resistant 2
}
}

Female deposition is implemented incorrectly. Right now, it is performed on
male alleles prior to zygote formation - it should happen post-zygote formation.
Since this construct doesn't have HDR, this should be fine. \cr
}
