% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-SplitDriveMF.R
\name{cubeSplitDrive}
\alias{cubeSplitDrive}
\title{Inheritance Cube: Split CRISPR Drive with 2 Resistance Alleles and male/female specific homing}
\usage{
cubeSplitDrive(
  cM = 1,
  chM = 0,
  crM = 0,
  ccM = cM,
  cchM = chM,
  ccrM = crM,
  cF = 1,
  chF = 0,
  crF = 0,
  ccF = cF,
  cchF = chF,
  ccrF = crF,
  dW = 0,
  dhW = 0,
  drW = 0,
  ddW = dW,
  ddhW = dhW,
  ddrW = drW,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Cutting efficiency in males, one Cas9 allele}

\item{chM}{Homing efficiency in males, one Cas9 allele}

\item{crM}{Resistance efficiency in males, one Cas9 allele}

\item{ccM}{Cutting efficiency in males, two Cas9 alleles}

\item{cchM}{Homing efficiency in males, two Cas9 alleles}

\item{ccrM}{Resistance efficiency in males, two Cas9 alleles}

\item{cF}{Cutting efficiency in females, one Cas9 allele}

\item{chF}{Homing efficiency in females, one Cas9 allele}

\item{crF}{Resistance efficiency in females, one Cas9 allele}

\item{ccF}{Cutting efficiency in females, two Cas9 alleles}

\item{cchF}{Homing efficiency in females, two Cas9 alleles}

\item{ccrF}{Resistance efficiency in females, two Cas9 alleles}

\item{dW}{Maternal deposition cutting, one Cas9 allele}

\item{dhW}{Maternal deposition homing, one Cas9 allele}

\item{drW}{Maternal deposition resistance, one Cas9 allele}

\item{ddW}{Maternal deposition cutting, two Cas9 alleles}

\item{ddhW}{Maternal deposition homing, two Cas9 alleles}

\item{ddrW}{Maternal deposition resistance, two Cas9 alleles}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a sex-specific version of a split CRISPR drive. At one locus is the Cas9, inherited
in a Mendelian fashion. At a second, unlinked, locus are the gRNAs. When the two loci occur
together, the gRNAs drive, with potential damaged alleles, but the Cas9 remains
Mendelian. It is assumed that this is an autosomal drive.
This drive corresponds to the \href{https://elifesciences.org/articles/51701}{confinable gene drive system}
developed by the Akbari lab.
}
