% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_f.R
\name{ml_f}
\alias{ml_f}
\title{Machine Learning Function for Soil Spectral Data}
\usage{
ml_f(
  x,
  y,
  smoother_selection,
  type_of_soil,
  model_selection = TRUE
)
}
\arguments{
\item{x}{A data frame or matrix containing spectral data.}

\item{y}{A vector containing corresponding soil laboratory measurements.}

\item{smoother_selection}{A parameter specifying the smoothing method to be applied during preprocessing.}

\item{type_of_soil}{A character string indicating the soil type for model calibration.}

\item{model_selection}{Logical; if `TRUE` (default), the function returns only the best-performing model.
If `FALSE`, it returns the results from all models.}
}
\value{
A data frame:
\describe{
  \item{If \code{model_selection = FALSE}}{Returns results for all models.}
  \item{If \code{model_selection = TRUE}}{Returns only the best-performing model result.}
}
}
\description{
This function applies several machine learning models (PCR, PLSR, Random Forest, LASSO, Cubist) 
to soil spectral data and compares their performance. Optionally, it can return the best-performing model.
}
\details{
The function merges spectral and laboratory data, preprocesses the data, and evaluates the following models:
\itemize{
  \item PCR (Principal Component Regression)
  \item PLSR (Partial Least Squares Regression)
  \item RF (Random Forest)
  \item LASSO regression
  \item Cubist regression
}

Each model's performance results are combined into a single results object. If \code{model_selection = TRUE}, 
the function returns the model with the highest performance metric (based on the 11th column of the results table).
}
\examples{
\donttest{
# Example usage:
results <- ml_f(
  x,
  y,
  smoother_selection = "savitzky",
  type_of_soil = "loam",
  model_selection = TRUE
)
}

}
