#'Method of Moments Estimation of Poisson distribution
#'@description function to get the method of moment estimate(s) of poisson distribution
#'@param data A numeric vector.
#'@param plot logical which controls whether the barplot of the data along with the probability curve of the theoretical poisson distribution with the estimated parameters.
#'@param curvecol color of the theoretical probability curve
#'@param ... additional plotting parameters
#'@importFrom stats dpois
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is poisson distribution
#'@examples
#'pois_est(data=rpois(1000,lambda=2),plot=TRUE)
#'pois_est(data=rpois(1000,lambda=0.2),plot=FALSE)#will not give the plot
#'@export
pois_est=function(data,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dpois(x,lambda=avg),from=0,to=floor(max(data)),n=floor(max(data))+1,add=T,col=curvecol)
  }
  output=list(avg)
  names(output)=c("lambda")
  return(output)
}
