% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simRHT2.R
\name{simRHT2}
\alias{simRHT2}
\title{Monte Carlo Simulation to obtain d and q constants for RHT2 function}
\usage{
simRHT2(n, p, nrep = 500, alpha = 0.75)
}
\arguments{
\item{n}{the sample size}

\item{p}{the number of variables}

\item{nrep}{the number of iteration. The default value is 500.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized. 
Allowed values are between 0.5 and 1 and the default is 0.75.}
}
\value{
a list with 2 elements:
\item{q}{The q value}
\item{d}{The d value}
}
\description{
Monte Carlo Simulation to obtain d and q constants for RHT2 function
}
\details{
\code{simRHT2} function computes d and q constants to construct an approximate 
F distribution of robust Hotelling T^2 statistic in high dimensional data. 
These constants are used in \code{RHT2} function.
For more detailed information, you can see the study by Bulut (2021).
}
\references{
Bulut, H (2021). A robust Hotelling test statistic for one sample case in highdimensional data,
Communication in Statistics: Theory and Methods.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
